/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.jmeter;

import java.io.File;
import javax.json.JsonObject;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import step.functions.handler.JsonBasedFunctionHandler;
import step.functions.io.Input;
import step.functions.io.Output;
import step.functions.io.OutputBuilder;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.plugins.jmeter.SampleListenerImpl;

public class JMeterLocalHandler
extends JsonBasedFunctionHandler {
    public static final String JMETER_TESTPLAN = "$jmeter.testplan.file";
    public static final String JMETER_LIBRARIES = "$jmeter.libraries";
    protected String jmeterHome;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output<JsonObject> handle(Input<JsonObject> message) throws Exception {
        ApplicationContextBuilder.ApplicationContext context = this.getCurrentContext();
        if (context.get((Object)"initialized") == null) {
            File jmeterLibFolder = this.retrieveFileVersion(JMETER_LIBRARIES, message.getProperties());
            this.jmeterHome = jmeterLibFolder.getAbsolutePath();
            this.updateClasspathSystemProperty();
            JMeterUtils.setJMeterHome((String)this.jmeterHome);
            JMeterUtils.loadJMeterProperties((String)(this.jmeterHome + "/bin/jmeter.properties"));
            JMeterUtils.initLogging();
            JMeterUtils.initLocale();
            context.put("initialized", (Object)true);
        }
        OutputBuilder out = new OutputBuilder();
        File testPlanFile = this.retrieveFileVersion(JMETER_TESTPLAN, message.getProperties());
        StandardJMeterEngine jmeter = new StandardJMeterEngine();
        final HashTree testPlanTree = SaveService.loadTree((File)testPlanFile);
        final Arguments arguments = this.createArguments(message);
        final SampleListenerImpl listener = new SampleListenerImpl(out);
        testPlanTree.traverse(new HashTreeTraverser(){

            public void subtractNode() {
            }

            public void processPath() {
            }

            public void addNode(Object node, HashTree subTree) {
                if (node instanceof TestPlan) {
                    testPlanTree.getTree(node).add((Object)listener);
                    testPlanTree.getTree(node).add((Object)arguments);
                }
            }
        });
        jmeter.configure(testPlanTree);
        try {
            jmeter.run();
        }
        finally {
            listener.collect();
        }
        return out.build();
    }

    private Arguments createArguments(Input<?> input) {
        Arguments arguments = new Arguments();
        JsonObject inputJson = (JsonObject)input.getPayload();
        if (inputJson != null) {
            for (String key : inputJson.keySet()) {
                arguments.addArgument(key, inputJson.getString(key));
            }
        }
        return arguments;
    }

    private void updateClasspathSystemProperty() {
        String cp = System.getProperty("java.class.path");
        File extFolder = new File(this.jmeterHome + "/lib/ext");
        if (extFolder.exists() && extFolder.isDirectory()) {
            for (File jar : extFolder.listFiles()) {
                cp = cp + ";" + jar.getAbsolutePath();
            }
        }
        System.setProperty("java.class.path", cp);
    }
}

