/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.java.handler;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import javax.json.JsonObject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import step.functions.handler.JsonBasedFunctionHandler;
import step.functions.io.Input;
import step.functions.io.Output;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.handlers.javahandler.Keyword;
import step.handlers.javahandler.KeywordHandler;

public class JavaJarHandler
extends JsonBasedFunctionHandler {
    public Output<JsonObject> handle(Input<JsonObject> input) throws Exception {
        this.pushRemoteApplicationContext("forkedBranch", "$function.library.file", input.getProperties());
        ApplicationContextBuilder.ApplicationContext context = this.getCurrentContext();
        String kwClassnames = (String)context.get((Object)"kwClassnames");
        if (kwClassnames == null) {
            kwClassnames = this.getKeywordClassList((URLClassLoader)this.getCurrentContext("forkedBranch").getClassLoader());
            context.put("kwClassnames", (Object)kwClassnames);
        }
        input.getProperties().put("$keywordClasses", kwClassnames);
        return this.delegate("forkedBranch", KeywordHandler.class.getName(), input);
    }

    private String getKeywordClassList(URLClassLoader cl) throws Exception {
        URL url = cl.getURLs()[0];
        try {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(new URL[]{url}).addClassLoader((ClassLoader)cl).setScanners(new Scanner[]{new MethodAnnotationsScanner()}));
            Set methods = reflections.getMethodsAnnotatedWith(Keyword.class);
            HashSet<String> kwClasses = new HashSet<String>();
            for (Method method : methods) {
                kwClasses.add(method.getDeclaringClass().getName());
            }
            StringBuilder kwClassnamesBuilder = new StringBuilder();
            kwClasses.forEach(kwClassname -> kwClassnamesBuilder.append(kwClassname + ";"));
            return kwClassnamesBuilder.toString();
        }
        catch (Exception e) {
            String errorMsg = "Error while looking for methods annotated with @Keyword in " + url.toString();
            throw new Exception(errorMsg, e);
        }
    }
}

