/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.js223.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.JsonObject;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import step.functions.handler.JsonBasedFunctionHandler;
import step.functions.io.Input;
import step.functions.io.Output;
import step.functions.io.OutputBuilder;

public class ScriptHandler
extends JsonBasedFunctionHandler {
    public static final String SCRIPT_LANGUAGE = "$scriptlanguage";
    public static final String SCRIPT_FILE = "$function.library.file";
    public static final String PLUGIN_LIBRARIES_FILE = "$plugin.libraries.file";
    public static final String LIBRARIES_FILE = "$libraries.file";
    public static final String ERROR_HANDLER_FILE = "$errorhandler.file";
    public static final Map<String, String> scriptLangugaeMap = new ConcurrentHashMap<String, String>();
    protected ScriptEngineManager manager;

    public ScriptHandler() {
        scriptLangugaeMap.put("groovy", "groovy");
        scriptLangugaeMap.put("javascript", "nashorn");
    }

    public Output<JsonObject> handle(Input<JsonObject> input) throws Exception {
        return (Output)this.runInContext("forkedBranch", () -> {
            OutputBuilder outputBuilder;
            block2: {
                Map properties = input.getProperties();
                File scriptFile = this.retrieveFileVersion(SCRIPT_FILE, properties);
                String scriptLanguage = (String)properties.get(SCRIPT_LANGUAGE);
                String engineName = scriptLangugaeMap.get(scriptLanguage);
                ScriptEngine engine = this.loadScriptEngine(engineName);
                outputBuilder = new OutputBuilder();
                Bindings binding = this.createBindings(input, outputBuilder, properties);
                try {
                    this.executeScript(scriptFile, binding, engine);
                }
                catch (Throwable e) {
                    boolean throwException = this.executeErrorHandlerScript(properties, engine, binding, outputBuilder, e);
                    if (!throwException) break block2;
                    outputBuilder.setError("Error while running script " + scriptFile.getName() + ": " + e.getMessage(), e);
                }
            }
            return outputBuilder.build();
        });
    }

    private boolean executeErrorHandlerScript(Map<String, String> properties, ScriptEngine engine, Bindings binding, OutputBuilder outputBuilder, Throwable exception) throws FileNotFoundException, Exception, IOException {
        File errorScriptFileVersion = this.retrieveFileVersion(ERROR_HANDLER_FILE, properties);
        if (errorScriptFileVersion != null) {
            File errorScriptFile = errorScriptFileVersion;
            binding.put("exception", (Object)exception);
            try {
                this.executeScript(errorScriptFile, binding, engine);
            }
            catch (Exception e) {
                outputBuilder.setError("Error while running error handler script: " + errorScriptFile.getName() + ". " + e.getMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(File scriptFile, Bindings binding, ScriptEngine engine) throws FileNotFoundException, Exception, IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scriptFile), Charset.forName("UTF-8")));){
            engine.eval((Reader)reader, binding);
        }
    }

    private Bindings createBindings(Input<?> input, OutputBuilder outputBuilder, Map<String, String> properties) {
        SimpleBindings binding = new SimpleBindings();
        binding.put("input", input.getPayload());
        binding.put("inputJson", (Object)input.getPayload().toString());
        binding.put("output", (Object)outputBuilder);
        binding.put("context", (Object)outputBuilder);
        binding.put("properties", (Object)this.mergeAllProperties(input));
        binding.put("session", (Object)this.getTokenReservationSession());
        binding.put("tokenSession", (Object)this.getTokenSession());
        return binding;
    }

    private ScriptEngine loadScriptEngine(String engineName) {
        this.manager = new ScriptEngineManager(Thread.currentThread().getContextClassLoader());
        ScriptEngine engine = this.manager.getEngineByName(engineName);
        if (engine == null) {
            throw new RuntimeException("Unable to find script engine with name '" + engineName + "'");
        }
        return engine;
    }
}

