/*
 * Decompiled with CFR 0.152.
 */
package step.migration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.Version;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.migration.MigrationManager;
import step.versionmanager.ControllerLog;
import step.versionmanager.VersionManager;

@Plugin(prio=3)
public class MigrationExecutionPlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MigrationExecutionPlugin.class);

    public void executionControllerStart(GlobalContext context) throws Exception {
        this.checkVersion(context);
        super.executionControllerStart(context);
    }

    private void checkVersion(GlobalContext context) {
        MigrationManager migrationManager = (MigrationManager)context.get(MigrationManager.class);
        VersionManager versionManager = (VersionManager)context.get(VersionManager.class);
        ControllerLog latestLog = versionManager.getLatestControllerLog();
        if (latestLog != null) {
            Version latestVersion = latestLog.getVersion();
            if (latestVersion == null) {
                latestVersion = new Version(3, 7, 0);
            }
            if (context.getCurrentVersion().compareTo(latestVersion) > 0) {
                logger.info("Starting controller with a newer version. Current version is " + context.getCurrentVersion() + ". Version of last start was " + latestVersion);
            } else if (context.getCurrentVersion().compareTo(latestVersion) < 0) {
                logger.info("Starting controller with an older version. Current version is " + context.getCurrentVersion() + ". Version of last start was " + latestVersion);
            }
            migrationManager.migrate(latestVersion, context.getCurrentVersion());
        }
    }
}

