/*
 * Decompiled with CFR 0.152.
 */
package step.grid.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.File;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.AgentRef;
import step.grid.GridFileService;
import step.grid.Token;
import step.grid.TokenWrapper;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.ObjectMapperResolver;
import step.grid.agent.handler.MessageHandler;
import step.grid.agent.handler.MessageHandlerPool;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.client.DefaultTokenLifecycleStrategy;
import step.grid.client.GridClient;
import step.grid.client.GridClientConfiguration;
import step.grid.client.TokenLifecycleStrategy;
import step.grid.client.TokenLifecycleStrategyCallback;
import step.grid.client.TokenPretender;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;
import step.grid.tokenpool.Identity;
import step.grid.tokenpool.Interest;
import step.grid.tokenpool.TokenRegistry;

public class GridClientImpl
implements GridClient {
    private static final Logger logger = LoggerFactory.getLogger(GridClientImpl.class);
    public static final String SELECTION_CRITERION_THREAD = "#THREADID#";
    private final GridClientConfiguration gridClientConfiguration;
    private final GridFileService fileService;
    private final TokenRegistry tokenRegistry;
    private final TokenLifecycleStrategy tokenLifecycleStrategy;
    private Client client;
    protected AgentTokenServices localAgentTokenServices;
    protected MessageHandlerPool localMessageHandlerPool;

    public GridClientImpl(TokenRegistry tokenRegistry, GridFileService fileService) {
        this(new GridClientConfiguration(), tokenRegistry, fileService);
    }

    public GridClientImpl(GridClientConfiguration gridClientConfiguration, TokenRegistry tokenRegistry, GridFileService fileService) {
        this(gridClientConfiguration, tokenRegistry, new DefaultTokenLifecycleStrategy(), fileService);
    }

    public GridClientImpl(GridClientConfiguration gridClientConfiguration, TokenRegistry tokenRegistry, TokenLifecycleStrategy tokenLifecycleStrategy, GridFileService fileService) {
        this.tokenLifecycleStrategy = tokenLifecycleStrategy;
        this.gridClientConfiguration = gridClientConfiguration;
        this.tokenRegistry = tokenRegistry;
        this.fileService = fileService;
        this.client = ClientBuilder.newClient();
        this.client.register(ObjectMapperResolver.class);
        this.client.register(JacksonJsonProvider.class);
        this.initLocalAgentServices();
        this.initLocalMessageHandlerPool();
    }

    private void initLocalAgentServices() {
        FileManagerClient fileManagerClient = new FileManagerClient(){

            public File requestFile(String uid, long lastModified) {
                return GridClientImpl.this.fileService.getRegisteredFile(uid);
            }

            public FileManagerClient.FileVersion requestFileVersion(String uid, long lastModified) {
                FileManagerClient.FileVersion fileVersion = new FileManagerClient.FileVersion();
                fileVersion.setFile(this.requestFile(uid, lastModified));
                fileVersion.setFileId(uid);
                fileVersion.setVersion(lastModified);
                return fileVersion;
            }

            public String getDataFolderPath() {
                return null;
            }
        };
        this.localAgentTokenServices = new AgentTokenServices(fileManagerClient);
        this.localAgentTokenServices.setApplicationContextBuilder(new ApplicationContextBuilder());
    }

    private void initLocalMessageHandlerPool() {
        this.localMessageHandlerPool = new MessageHandlerPool(this.localAgentTokenServices);
    }

    @Override
    public TokenWrapper getLocalTokenHandle() {
        Token localToken = new Token();
        localToken.setId(UUID.randomUUID().toString());
        localToken.setAgentid("local");
        localToken.setAttributes(new HashMap());
        localToken.setSelectionPatterns(new HashMap());
        TokenWrapper tokenWrapper = new TokenWrapper(localToken, new AgentRef("local", "localhost", "default"));
        return tokenWrapper;
    }

    @Override
    public TokenWrapper getTokenHandle(Map<String, String> attributes, Map<String, Interest> interests, boolean createSession) throws AgentCommunicationException {
        TokenPretender tokenPretender = new TokenPretender(attributes, interests);
        TokenWrapper tokenWrapper = this.getToken(tokenPretender);
        if (createSession) {
            try {
                this.reserveSession(tokenWrapper.getAgent(), tokenWrapper.getToken());
                tokenWrapper.setHasSession(true);
            }
            catch (AgentCommunicationException e) {
                this.tokenLifecycleStrategy.afterTokenReservationError(this.getTokenLifecycleCallback(tokenWrapper), tokenWrapper, e);
                logger.warn("Error while reserving session for token " + tokenWrapper.getID() + ". Returning token to pool. Subsequent call to this token may fail or leaks may appear on the agent side.", (Throwable)e);
                this.returnTokenHandle(tokenWrapper);
                throw e;
            }
        }
        return tokenWrapper;
    }

    @Override
    public void returnTokenHandle(TokenWrapper tokenWrapper) throws AgentCommunicationException {
        try {
            if (tokenWrapper.hasSession()) {
                this.releaseSession(tokenWrapper.getAgent(), tokenWrapper.getToken());
            }
        }
        catch (Exception e) {
            this.tokenLifecycleStrategy.afterTokenReleaseError(this.getTokenLifecycleCallback(tokenWrapper), tokenWrapper, e);
            throw e;
        }
        finally {
            if (!tokenWrapper.getToken().getAgentid().equals("local")) {
                this.tokenRegistry.returnToken(tokenWrapper);
            }
        }
    }

    @Override
    public OutputMessage call(TokenWrapper tokenWrapper, String function, JsonObject argument, String handler, FileManagerClient.FileVersionId handlerPackage, Map<String, String> properties, int callTimeout) throws Exception {
        OutputMessage output;
        Token token = tokenWrapper.getToken();
        AgentRef agent = tokenWrapper.getAgent();
        InputMessage message = new InputMessage();
        message.setArgument(argument);
        message.setFunction(function);
        message.setHandler(handler);
        message.setHandlerPackage(handlerPackage);
        message.setProperties(properties);
        message.setCallTimeout(callTimeout);
        if (token.isLocal()) {
            output = this.callLocalToken(token, message);
        } else {
            try {
                output = this.callAgent(agent, token, message);
                this.tokenLifecycleStrategy.afterTokenCall(this.getTokenLifecycleCallback(tokenWrapper), tokenWrapper, output);
            }
            catch (Exception e) {
                this.tokenLifecycleStrategy.afterTokenCallError(this.getTokenLifecycleCallback(tokenWrapper), tokenWrapper, e);
                throw e;
            }
        }
        return output;
    }

    protected TokenLifecycleStrategyCallback getTokenLifecycleCallback(TokenWrapper tokenWrapper) {
        return new TokenLifecycleStrategyCallback(this.tokenRegistry, tokenWrapper.getID());
    }

    private OutputMessage callLocalToken(Token token, InputMessage message) throws Exception {
        AgentTokenWrapper agentTokenWrapper = new AgentTokenWrapper(token);
        agentTokenWrapper.setServices(this.localAgentTokenServices);
        MessageHandler h = this.localMessageHandlerPool.get(message.getHandler());
        OutputMessage output = h.handle(agentTokenWrapper, message);
        return output;
    }

    private void reserveSession(AgentRef agentRef, Token token) throws AgentCommunicationException {
        this.call(agentRef, token, "/reserve", builder -> builder.get(), this.gridClientConfiguration.getReserveSessionTimeout());
    }

    private OutputMessage callAgent(AgentRef agentRef, Token token, InputMessage message) throws AgentCommunicationException {
        return (OutputMessage)this.call(agentRef, token, "/process", builder -> {
            Entity entity = Entity.entity((Object)message, (String)"application/json");
            return builder.post(entity);
        }, response -> response.readEntity(OutputMessage.class), this.gridClientConfiguration.getReadTimeoutOffset() + message.getCallTimeout());
    }

    private void releaseSession(AgentRef agentRef, Token token) throws AgentCommunicationException {
        this.call(agentRef, token, "/release", builder -> builder.get(), this.gridClientConfiguration.getReleaseSessionTimeout());
    }

    private void call(AgentRef agentRef, Token token, String cmd, Function<Invocation.Builder, Response> f, int callTimeout) throws AgentCommunicationException {
        this.call(agentRef, token, cmd, f, null, callTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(AgentRef agentRef, Token token, String cmd, Function<Invocation.Builder, Response> f, Function<Response, Object> mapper, int readTimeout) throws AgentCommunicationException {
        String agentUrl = agentRef.getAgentUrl();
        int connectionTimeout = this.gridClientConfiguration.getReadTimeoutOffset();
        Invocation.Builder builder = this.client.target(agentUrl + "/token/" + token.getId() + cmd).request().property("jersey.config.client.readTimeout", (Object)readTimeout).property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
        try (Response response = null;){
            try {
                response = f.apply(builder);
            }
            catch (ProcessingException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof SocketTimeoutException) {
                    String causeMessage = cause.getMessage();
                    if (causeMessage != null && causeMessage.contains("Read timed out")) {
                        throw new AgentCallTimeoutException(readTimeout, (Throwable)e);
                    }
                    throw new AgentCommunicationException(e);
                }
                throw new AgentCommunicationException(e);
            }
            catch (Exception e) {
                throw new AgentCommunicationException(e);
            }
            if (response.getStatus() != 204 && response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new AgentSideException(error);
            }
            if (mapper != null) {
                Object object = mapper.apply(response);
                return object;
            }
            Object var11_15 = null;
            return var11_15;
        }
    }

    private TokenWrapper getToken(Identity tokenPretender) {
        TokenWrapper adapterToken = null;
        try {
            this.addThreadIdInterest(tokenPretender);
            adapterToken = this.tokenRegistry.selectToken(tokenPretender, this.gridClientConfiguration.getMatchExistsTimeout(), this.gridClientConfiguration.getNoMatchExistsTimeout());
        }
        catch (TimeoutException e) {
            StringBuilder interestList = new StringBuilder();
            if (tokenPretender.getInterests() != null) {
                tokenPretender.getInterests().forEach((k, v) -> interestList.append(k + "=" + v + " and "));
            }
            String desc = " selection criteria " + interestList.toString() + " accepting attributes " + tokenPretender.getAttributes();
            throw new RuntimeException("Not able to find any agent token matching " + desc);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.markTokenWithThreadId(adapterToken);
        return adapterToken;
    }

    private void markTokenWithThreadId(TokenWrapper adapterToken) {
        if (adapterToken.getAttributes() != null) {
            adapterToken.getAttributes().put(SELECTION_CRITERION_THREAD, Long.toString(Thread.currentThread().getId()));
        }
    }

    private void addThreadIdInterest(Identity tokenPretender) {
        if (tokenPretender.getInterests() != null) {
            tokenPretender.getInterests().put(SELECTION_CRITERION_THREAD, new Interest(Pattern.compile("^" + Long.toString(Thread.currentThread().getId()) + "$"), false));
        }
    }

    @Override
    public String registerFile(File file) {
        return this.fileService.registerFile(file);
    }

    @Override
    public File getRegisteredFile(String fileHandle) {
        return this.fileService.getRegisteredFile(fileHandle);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public static class AgentSideException
    extends AgentCommunicationException {
        public AgentSideException(String message) {
            super(message);
        }
    }

    public static class AgentCallTimeoutException
    extends AgentCommunicationException {
        private final long callTimeout;

        public AgentCallTimeoutException(long callTimeout, String message, Throwable cause) {
            super(message, cause);
            this.callTimeout = callTimeout;
        }

        public AgentCallTimeoutException(long callTimeout, Throwable cause) {
            super(cause);
            this.callTimeout = callTimeout;
        }

        public long getCallTimeout() {
            return this.callTimeout;
        }
    }

    public static class AgentCommunicationException
    extends Exception {
        private static final long serialVersionUID = 4337204149079143691L;

        public AgentCommunicationException(String message, Throwable cause) {
            super(message, cause);
        }

        public AgentCommunicationException(Throwable cause) {
            super(cause);
        }

        public AgentCommunicationException(String message) {
            super(message);
        }
    }
}

