/*
 * Decompiled with CFR 0.152.
 */
package step.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import step.grid.AgentRef;
import step.grid.Grid;
import step.grid.TokenWrapper;
import step.grid.TokenWrapperOwner;
import step.grid.reports.TokenGroupCapacity;
import step.grid.tokenpool.Interest;
import step.grid.tokenpool.Token;

public class GridReportBuilder {
    private Grid grid;
    private static final String UID_KEY = "id";
    private static final String URL_KEY = "url";

    public GridReportBuilder(Grid adapterGrid) {
        this.grid = adapterGrid;
    }

    public List<TokenGroupCapacity> getUsageByIdentity(List<String> groupbys) {
        HashMap<HashMap<String, String>, TokenGroupCapacity> countsByIdentity = new HashMap<HashMap<String, String>, TokenGroupCapacity>();
        for (Token<TokenWrapper> token : this.grid.getTokens()) {
            TokenWrapper aToken = token.getObject();
            HashMap<String, String> key = new HashMap<String, String>();
            for (String groupby : groupbys) {
                key.put(groupby, this.getValue(groupby, aToken));
            }
            if (!countsByIdentity.containsKey(key)) {
                countsByIdentity.put(key, new TokenGroupCapacity(key));
            }
            TokenGroupCapacity c = (TokenGroupCapacity)countsByIdentity.get(key);
            c.incrementCapacity();
            c.incrementUsage(aToken.getState());
        }
        return new ArrayList<TokenGroupCapacity>(countsByIdentity.values());
    }

    public Set<String> getTokenAttributeKeys() {
        HashSet<String> result = new HashSet<String>();
        for (Token<TokenWrapper> token : this.grid.getTokens()) {
            result.addAll(token.getObject().getAttributes().keySet());
            if (token.getObject().getInterests() == null) continue;
            result.addAll(token.getObject().getInterests().keySet());
        }
        return result;
    }

    private String getValue(String key, TokenWrapper aToken) {
        Interest interest;
        String attribute;
        if (key.equals(UID_KEY)) {
            return aToken.getID();
        }
        if (key.equals(URL_KEY)) {
            AgentRef ref = aToken.getAgent();
            return ref != null ? ref.getAgentUrl() : "-";
        }
        if (aToken.getAttributes() != null && (attribute = aToken.getAttributes().get(key)) != null) {
            return attribute;
        }
        if (aToken.getInterests() != null && (interest = aToken.getInterests().get(key)) != null) {
            return interest.getSelectionPattern().toString();
        }
        return null;
    }

    public List<TokenWrapper> getTokenAssociations(boolean onlyWithOwner) {
        ArrayList<TokenWrapper> tokens = new ArrayList<TokenWrapper>();
        for (Token<TokenWrapper> token : this.grid.getTokens()) {
            TokenWrapperOwner currentOwner = token.getObject().getCurrentOwner();
            if (currentOwner == null && (currentOwner != null || onlyWithOwner)) continue;
            tokens.add(token.getObject());
        }
        return tokens;
    }
}

