/*
 * Decompiled with CFR 0.152.
 */
package step.grid.filemanager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import step.commons.helpers.FileHelper;
import step.grid.filemanager.FileProvider;

public class FileManagerServer
implements FileProvider {
    ConcurrentHashMap<String, File> registry = new ConcurrentHashMap();
    ConcurrentHashMap<File, String> reverseRegistry = new ConcurrentHashMap();

    public String registerFile(final File file) {
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("Unable to find or read file " + file.getAbsolutePath());
        }
        String handle = this.reverseRegistry.computeIfAbsent(file, new Function<File, String>(){

            @Override
            public String apply(File t) {
                String handle = UUID.randomUUID().toString();
                FileManagerServer.this.registry.put(handle, file);
                return handle;
            }
        });
        return handle;
    }

    public FileProvider.TransportableFile getTransportableFile(String fileHandle) {
        File transferFile = this.getFile(fileHandle);
        try {
            boolean isDirectory;
            byte[] bytes;
            if (transferFile.isDirectory()) {
                bytes = FileHelper.zipDirectory((File)transferFile);
                isDirectory = true;
            } else {
                bytes = Files.readAllBytes(transferFile.toPath());
                isDirectory = false;
            }
            return new FileProvider.TransportableFile(transferFile.getName(), isDirectory, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading file with handle " + fileHandle + " mapped to '" + transferFile.getAbsolutePath() + "'", e);
        }
    }

    public File getFile(String fileHandle) {
        return this.registry.get(fileHandle);
    }
}

