/*
 * Decompiled with CFR 0.152.
 */
package step.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.jvnet.hk2.internal.Closeable;

public class ExpiringMap<T, V>
implements Map<T, V>,
Closeable {
    long keepaliveTimeout;
    Timer keepaliveTimeoutCheckTimer;
    private ConcurrentHashMap<T, Wrapper> map = new ConcurrentHashMap();

    public ExpiringMap(long keepaliveTimeout) {
        this(keepaliveTimeout, keepaliveTimeout / 10L);
    }

    public ExpiringMap(long keepaliveTimeout, long checkIntervalMs) {
        this.keepaliveTimeout = keepaliveTimeout;
        this.keepaliveTimeoutCheckTimer = new Timer();
        this.keepaliveTimeoutCheckTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    ExpiringMap.this.keepaliveTimeoutCheck();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, checkIntervalMs, checkIntervalMs);
    }

    private void keepaliveTimeoutCheck() {
        if (this.keepaliveTimeout > 0L) {
            long now = System.currentTimeMillis();
            Set<Map.Entry<T, Wrapper>> set = this.map.entrySet();
            for (Map.Entry<T, Wrapper> entry : set) {
                if (entry.getValue().lasttouch + this.keepaliveTimeout >= now) continue;
                set.remove(entry);
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Wrapper w : this.map.values()) {
            if (!w.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Wrapper w = this.map.get(key);
        return w != null ? (V)w.value : null;
    }

    @Override
    public synchronized V put(T key, V value) {
        Wrapper wrapper = this.map.put(key, new Wrapper(value));
        return wrapper != null ? (V)wrapper.value : null;
    }

    @Override
    public synchronized V remove(Object key) {
        Wrapper w = this.map.remove(key);
        return w != null ? (V)w.value : null;
    }

    @Override
    public void putAll(Map<? extends T, ? extends V> m) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Wrapper entry : this.map.values()) {
            values.add(entry.value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<T, V>> entrySet() {
        HashSet<Map.Entry<T, V>> result = new HashSet<Map.Entry<T, V>>();
        for (Map.Entry<T, Wrapper> e : this.map.entrySet()) {
            result.add(new Entry(e.getKey(), e.getValue().value));
        }
        return result;
    }

    public boolean close() {
        this.keepaliveTimeoutCheckTimer.cancel();
        return true;
    }

    public synchronized void putOrTouch(T key, V value) {
        if (this.containsKey(key)) {
            this.touch(key);
        } else {
            this.put(key, value);
        }
    }

    public synchronized void touch(T key) {
        Wrapper v = this.map.get(key);
        if (v != null) {
            v.lasttouch = System.currentTimeMillis();
        }
    }

    public boolean isClosed() {
        return false;
    }

    private class Entry
    implements Map.Entry<T, V> {
        T key;
        V value;

        public Entry(T key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public T getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new RuntimeException("Not implemented");
        }
    }

    private class Wrapper {
        long lasttouch;
        V value;

        public Wrapper(V value) {
            this.value = value;
            this.lasttouch = System.currentTimeMillis();
        }
    }
}

