/*
 * Decompiled with CFR 0.152.
 */
package step.grid.tokenpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.tokenpool.AffinityEvaluator;
import step.grid.tokenpool.Identity;
import step.grid.tokenpool.Token;
import step.grid.tokenpool.WaitingPretender;

public class TokenPool<P extends Identity, F extends Identity> {
    private static final Logger logger = LoggerFactory.getLogger(TokenPool.class);
    final AffinityEvaluator affinityEval;
    final Map<String, Token<F>> tokens = new HashMap<String, Token<F>>();
    final List<WaitingPretender<P, F>> waitingPretenders = Collections.synchronizedList(new LinkedList());
    long keepaliveTimeout;
    Timer keepaliveTimeoutCheckTimer;

    public TokenPool(AffinityEvaluator affinityEval) {
        this.affinityEval = affinityEval;
        this.keepaliveTimeout = -1L;
        this.keepaliveTimeoutCheckTimer = new Timer();
        this.keepaliveTimeoutCheckTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    TokenPool.this.keepaliveTimeoutCheck();
                }
                catch (Exception e) {
                    logger.error("An error occurred while running timer.", (Throwable)e);
                }
            }
        }, 10000L, 10000L);
    }

    public void setKeepaliveTimeout(long timeout) {
        this.keepaliveTimeout = timeout;
    }

    public F selectToken(P pretender, long timeout) throws TimeoutException, InterruptedException {
        return this.selectToken(pretender, timeout, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public F selectToken(P pretender, long matchExistsTimeout, long noMatchExistsTimeout) throws TimeoutException, InterruptedException {
        boolean poolContainsMatchingToken = false;
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            MatchingResult matchingResult = this.searchMatchesInTokenList(pretender);
            Token bestMatch = matchingResult.bestAvailableMatch;
            if (matchingResult.bestAvailableMatch != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found token without queuing. Pretender=" + pretender.toString() + ". Token=" + bestMatch.toString());
                }
                bestMatch.available = false;
                return (F)bestMatch.object;
            }
            if (matchingResult.bestMatch != null) {
                poolContainsMatchingToken = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No free token found. Enqueuing... Pretender=" + pretender.toString());
        }
        WaitingPretender waitingPretender = new WaitingPretender(pretender);
        try {
            this.waitingPretenders.add(waitingPretender);
            WaitingPretender waitingPretender2 = waitingPretender;
            synchronized (waitingPretender2) {
                long waitTime = poolContainsMatchingToken ? matchExistsTimeout : noMatchExistsTimeout;
                waitingPretender.wait(waitTime);
            }
            if (waitingPretender.associatedToken != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found token after queuing. Pretender=" + pretender.toString() + ". Token=" + waitingPretender.associatedToken.toString());
                }
                waitingPretender2 = waitingPretender.associatedToken.object;
                return (F)waitingPretender2;
            }
            logger.warn("Timeout occurred while selecting token. Pretender=" + pretender.toString());
            throw new TimeoutException("Timeout occurred while selecting token.");
        }
        finally {
            this.waitingPretenders.remove(waitingPretender);
        }
    }

    private MatchingResult searchMatchesInTokenList(P pretender) {
        Token<F> bestMatch = null;
        int bestScore = -1;
        Token<F> bestAvailableMatch = null;
        int bestAvailableScore = -1;
        for (Token<F> token : this.tokens.values()) {
            int score = this.affinityEval.getAffinityScore((Identity)pretender, (Identity)token.object);
            if (score != -1 && score > bestScore) {
                bestScore = score;
                bestMatch = token;
            }
            if (!token.available || score == -1 || score <= bestAvailableScore) continue;
            bestAvailableScore = score;
            bestAvailableMatch = token;
        }
        return new MatchingResult(bestMatch, bestAvailableMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingPretendersWithoutMatchInTokenList() {
        List<WaitingPretender<P, F>> list = this.waitingPretenders;
        synchronized (list) {
            for (WaitingPretender<P, F> waitingPretender : this.waitingPretenders) {
                if (this.hasWaitingPretenderAMatchInTokenList(waitingPretender)) continue;
                WaitingPretender<P, F> waitingPretender2 = waitingPretender;
                synchronized (waitingPretender2) {
                    waitingPretender.notify();
                }
            }
        }
    }

    private boolean hasWaitingPretenderAMatchInTokenList(WaitingPretender<P, F> waitingPretender) {
        MatchingResult matchingResult = this.searchMatchesInTokenList(waitingPretender.pretender);
        return matchingResult.bestMatch != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToken(F object) {
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            if (logger.isDebugEnabled()) {
                logger.debug("Returning token. Token=" + object.toString());
            }
            Token<F> token = this.findToken(object);
            if (token.invalidated) {
                this.removeToken(token);
            } else {
                token.available = true;
                this.checkForMatchInPretenderWaitingQueue(token);
            }
        }
    }

    private void removeToken(Token<F> token) {
        this.tokens.remove(token.getObject().getID());
        this.notifyWaitingPretendersWithoutMatchInTokenList();
    }

    private Token<F> findToken(F object) {
        return this.tokens.get(object.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String offerToken(F object) {
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            Token<F> token;
            if (logger.isDebugEnabled()) {
                logger.debug("Offering token. Token=" + object.toString());
            }
            if ((token = this.findToken(object)) == null) {
                token = new Token<F>(object);
                token.available = true;
                this.tokens.put(token.object.getID(), token);
                this.checkForMatchInPretenderWaitingQueue(token);
            }
            this.keepaliveToken(token);
            return token.getObject().getID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepaliveTimeoutCheck() {
        if (this.keepaliveTimeout > 0L) {
            Map<String, Token<F>> map = this.tokens;
            synchronized (map) {
                long now = System.currentTimeMillis();
                ArrayList<Token<F>> invalidTokens = new ArrayList<Token<F>>();
                for (Token<Object> token : this.tokens.values()) {
                    if (token.lastTouch + this.keepaliveTimeout >= now) continue;
                    invalidTokens.add(token);
                }
                for (Token<Object> token : invalidTokens) {
                    this.invalidateToken(token);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepaliveToken(String id) {
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            Token<F> token = this.tokens.get(id);
            this.keepaliveToken(token);
        }
    }

    private void keepaliveToken(Token<F> token) {
        token.lastTouch = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String id) {
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            Token<F> token = this.tokens.get(id);
            this.invalidateToken(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateToken(F object) {
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            Token<F> token = this.findToken(object);
            this.invalidateToken(token);
        }
    }

    private void invalidateToken(Token<F> token) {
        if (token != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating token. Token=" + token.toString());
            }
            token.invalidated = true;
            if (token.available) {
                this.removeToken(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMatchInPretenderWaitingQueue(Token<F> token) {
        WaitingPretender<P, F> pretenderMatch = this.selectPretender(token);
        if (pretenderMatch != null) {
            token.available = false;
            pretenderMatch.associatedToken = token;
            WaitingPretender<P, F> waitingPretender = pretenderMatch;
            synchronized (waitingPretender) {
                pretenderMatch.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WaitingPretender<P, F> selectPretender(Token<F> token) {
        List<WaitingPretender<P, F>> list = this.waitingPretenders;
        synchronized (list) {
            for (WaitingPretender<P, F> pretender : this.waitingPretenders) {
                if (pretender.associatedToken != null || this.affinityEval.getAffinityScore((Identity)pretender.pretender, (Identity)token.object) < 0) continue;
                return pretender;
            }
        }
        return null;
    }

    public int getSize() {
        return this.tokens.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token<F>> getTokens() {
        Map<String, Token<F>> map = this.tokens;
        synchronized (map) {
            return new ArrayList<Token<F>>(this.tokens.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<P> getWaitingPretenders() {
        List<WaitingPretender<P, F>> list = this.waitingPretenders;
        synchronized (list) {
            ArrayList result = new ArrayList(this.waitingPretenders.size());
            for (WaitingPretender<P, F> waitingPretender : this.waitingPretenders) {
                result.add(waitingPretender.pretender);
            }
            return result;
        }
    }

    private class MatchingResult {
        Token<F> bestMatch;
        Token<F> bestAvailableMatch;

        public MatchingResult(Token<F> bestMatch, Token<F> bestAvailableMatch) {
            this.bestMatch = bestMatch;
            this.bestAvailableMatch = bestAvailableMatch;
        }
    }
}

