/*
 * Decompiled with CFR 0.152.
 */
package step.grid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import step.grid.AgentRef;
import step.grid.Token;
import step.grid.tokenpool.Identity;
import step.grid.tokenpool.Interest;

public class TokenWrapper
implements Identity {
    private Token token;
    private AgentRef agent;
    private Object currentOwner;
    private boolean hasSession = false;

    public TokenWrapper() {
    }

    public TokenWrapper(Token token, AgentRef agent) {
        this.token = token;
        this.agent = agent;
    }

    public Map<String, String> getAttributes() {
        return this.token.getAttributes();
    }

    public Map<String, Interest> getInterests() {
        return this.token.getSelectionPatterns();
    }

    @JsonIgnore
    public String getID() {
        return this.token.getId();
    }

    public Token getToken() {
        return this.token;
    }

    public AgentRef getAgent() {
        return this.agent;
    }

    public Object getCurrentOwner() {
        return this.currentOwner;
    }

    public void setCurrentOwner(Object currentOwner) {
        this.currentOwner = currentOwner;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setAgent(AgentRef agent) {
        this.agent = agent;
    }

    public boolean hasSession() {
        return this.hasSession;
    }

    public void setHasSession(boolean hasSession) {
        this.hasSession = hasSession;
    }

    public String toString() {
        return "AdapterToken [id=" + this.getID() + ", attributes=" + this.getAttributes() + ", interests=" + this.getInterests() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        result = 31 * result + (this.getInterests() == null ? 0 : this.getInterests().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenWrapper other = (TokenWrapper)obj;
        if (this.getAttributes() == null ? other.getAttributes() != null : !this.getAttributes().equals(other.getAttributes())) {
            return false;
        }
        return !(this.getInterests() == null ? other.getInterests() != null : !this.getInterests().equals(other.getInterests()));
    }
}

