/*
 * Decompiled with CFR 0.152.
 */
package step.grid;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import step.grid.AgentRef;
import step.grid.ExpiringMap;
import step.grid.GridFileService;
import step.grid.GridServices;
import step.grid.Token;
import step.grid.TokenWrapper;
import step.grid.agent.RegistrationMessage;
import step.grid.filemanager.FileManagerServer;
import step.grid.filemanager.FileProvider;
import step.grid.tokenpool.Identity;
import step.grid.tokenpool.SimpleAffinityEvaluator;
import step.grid.tokenpool.TokenPool;
import step.grid.tokenpool.TokenRegistry;

public class Grid
implements TokenRegistry,
GridFileService {
    public static final String LOCAL_AGENT = "local";
    private ExpiringMap<String, AgentRef> agentRefs;
    private TokenPool<Identity, TokenWrapper> tokenPool;
    private final Integer port;
    private final Integer keepAliveTimeout;
    private Server server;
    private FileManagerServer fileManager = new FileManagerServer();

    public Grid(Integer port) {
        this.port = port;
        this.keepAliveTimeout = 60000;
    }

    public Grid(Integer port, Integer ttl) {
        this.port = port;
        this.keepAliveTimeout = ttl;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void start() throws Exception {
        this.initializeAgentRefs();
        this.initializeTokenPool();
        this.initializeServer();
        this.startServer();
    }

    private void initializeAgentRefs() {
        this.agentRefs = new ExpiringMap(this.keepAliveTimeout.intValue());
    }

    private void initializeTokenPool() {
        this.tokenPool = new TokenPool(new SimpleAffinityEvaluator());
        this.tokenPool.setKeepaliveTimeout(this.keepAliveTimeout.intValue());
    }

    private void initializeServer() {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.packages(new String[]{GridServices.class.getPackage().getName()});
        resourceConfig.register(JacksonJaxbJsonProvider.class);
        final Grid grid = this;
        resourceConfig.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(grid).to(Grid.class);
                this.bind(Grid.this.fileManager).to(FileProvider.class);
            }
        });
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder sh = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(sh, "/*");
        this.server = new Server(this.port.intValue());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{context});
        this.server.setHandler((Handler)contexts);
    }

    private void startServer() throws Exception {
        this.server.start();
    }

    protected void handleRegistrationMessage(RegistrationMessage message) {
        AgentRef agentRef = message.getAgentRef();
        this.agentRefs.putOrTouch(agentRef.getAgentId(), agentRef);
        for (Token token : message.getTokens()) {
            this.tokenPool.offerToken(new TokenWrapper(token, agentRef));
        }
    }

    @Override
    public TokenWrapper selectToken(Identity pretender, long matchTimeout, long noMatchTimeout) throws TimeoutException, InterruptedException {
        return this.tokenPool.selectToken(pretender, matchTimeout, noMatchTimeout);
    }

    @Override
    public void returnToken(TokenWrapper object) {
        this.tokenPool.returnToken(object);
    }

    @Override
    public String registerFile(File file) {
        return this.fileManager.registerFile(file);
    }

    @Override
    public File getRegisteredFile(String fileHandle) {
        return this.fileManager.getFile(fileHandle);
    }

    @Override
    public List<step.grid.tokenpool.Token<TokenWrapper>> getTokens() {
        return this.tokenPool.getTokens();
    }

    public Collection<AgentRef> getAgents() {
        return this.agentRefs.values();
    }

    public int getServerPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }
}

