/*
 * Decompiled with CFR 0.152.
 */
package step.grid;

import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import step.grid.Grid;
import step.grid.agent.RegistrationMessage;
import step.grid.filemanager.FileProvider;

@Path(value="/grid")
public class GridServices {
    @Inject
    Grid grid;
    @Inject
    FileProvider fileManager;

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/register")
    public void register(RegistrationMessage message) {
        this.grid.handleRegistrationMessage(message);
    }

    @GET
    @Path(value="/file/{id}")
    public Response getFile(@PathParam(value="id") String id) throws IOException {
        final FileProvider.TransportableFile file = this.fileManager.getTransportableFile(id);
        StreamingOutput fileStream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                output.write(file.getBytes());
                output.flush();
            }
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + file.getName() + "; type = " + (file.isDirectory() ? "dir" : "file"))).build();
    }
}

