/*
 * Decompiled with CFR 0.152.
 */
package step.grid.tokenpool;

import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.tokenpool.AffinityEvaluator;
import step.grid.tokenpool.Identity;
import step.grid.tokenpool.Interest;

public class SimpleAffinityEvaluator
implements AffinityEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAffinityEvaluator.class);

    @Override
    public int getAffinityScore(Identity i1, Identity i2) {
        int pretenderScore = this.getScore(i1, i2);
        if (pretenderScore != -1) {
            int tokenScore = this.getScore(i2, i1);
            if (tokenScore != -1) {
                this.log(i1, i2, pretenderScore, tokenScore);
                return pretenderScore + tokenScore;
            }
            this.log(i1, i2, pretenderScore, tokenScore);
            return -1;
        }
        this.log(i1, i2, pretenderScore, 0);
        return -1;
    }

    private void log(Identity i1, Identity i2, int pretenderScore, int tokenScore) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calculated affinity between identity 1 (" + i1.toString() + ") and identity 2 (" + i2.toString() + "). TokenScore: " + tokenScore + ". PretenderScore: " + pretenderScore);
        }
    }

    private int getScore(Identity pretender, Identity queen) {
        int score = 0;
        if (queen.getInterests() != null) {
            for (String criterionAttribute : queen.getInterests().keySet()) {
                String attribute = (String)pretender.getAttributes().get(criterionAttribute);
                Interest interest = (Interest)queen.getInterests().get(criterionAttribute);
                if (attribute != null) {
                    Matcher matcher = interest.getSelectionPattern().matcher(attribute);
                    if (matcher.matches()) {
                        ++score;
                        continue;
                    }
                    if (!interest.isMust()) continue;
                    return -1;
                }
                if (!interest.isMust()) continue;
                return -1;
            }
        }
        return score;
    }
}

