/*
 * Decompiled with CFR 0.152.
 */
package step.grid.contextbuilder;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import step.grid.contextbuilder.ApplicationContextFactory;
import step.grid.contextbuilder.ClassPathHelper;
import step.grid.filemanager.FileManagerClient;
import step.grid.filemanager.FileProviderException;

public class RemoteApplicationContextFactory
extends ApplicationContextFactory {
    protected FileManagerClient.FileVersionId remoteClassLoaderFolder;
    protected FileManagerClient fileManager;

    public RemoteApplicationContextFactory(FileManagerClient fileManager, FileManagerClient.FileVersionId remoteClassLoaderFolder) {
        this.fileManager = fileManager;
        this.remoteClassLoaderFolder = remoteClassLoaderFolder;
    }

    @Override
    public String getId() {
        return this.remoteClassLoaderFolder.getFileId();
    }

    @Override
    public boolean requiresReload() throws FileProviderException {
        FileManagerClient.FileVersion localClassLoaderFolder = this.requestLatestClassPathFolder();
        return localClassLoaderFolder.isModified();
    }

    private FileManagerClient.FileVersion requestLatestClassPathFolder() throws FileProviderException {
        return this.fileManager.requestFileVersion(this.remoteClassLoaderFolder.getFileId(), this.remoteClassLoaderFolder.getVersion());
    }

    @Override
    public ClassLoader buildClassLoader(ClassLoader parentClassLoader) throws FileProviderException {
        FileManagerClient.FileVersion localClassLoaderFolder = this.requestLatestClassPathFolder();
        List<URL> urls = localClassLoaderFolder.getFile().isDirectory() ? ClassPathHelper.forAllJarsInFolder(localClassLoaderFolder.getFile()) : ClassPathHelper.forSingleFile(localClassLoaderFolder.getFile());
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader classLoader = new URLClassLoader(urlArray, parentClassLoader);
        return classLoader;
    }
}

