/*
 * Decompiled with CFR 0.152.
 */
package step.grid.bootstrap;

import java.io.IOException;
import java.util.concurrent.Callable;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.MessageHandler;
import step.grid.agent.handler.MessageHandlerPool;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.contextbuilder.RemoteApplicationContextFactory;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;

public class BootstrapManager {
    ApplicationContextBuilder contextBuilder;
    FileManagerClient fileManager;
    AgentTokenServices agentTokenServices;

    public BootstrapManager(AgentTokenServices agentTokenServices, boolean isTechnicalBootstrap) {
        this.agentTokenServices = agentTokenServices;
        this.fileManager = agentTokenServices.getFileManagerClient();
        this.contextBuilder = new ApplicationContextBuilder();
    }

    public OutputMessage runBootstraped(final AgentTokenWrapper token, final InputMessage message, final String handlerClass, FileManagerClient.FileVersionId handlerPackage) throws IOException, Exception {
        this.contextBuilder.resetContext();
        if (message.getHandlerPackage() != null) {
            this.contextBuilder.pushContext(new RemoteApplicationContextFactory(this.fileManager, message.getHandlerPackage()));
        }
        return this.contextBuilder.runInContext(new Callable<OutputMessage>(){

            @Override
            public OutputMessage call() throws Exception {
                MessageHandlerPool handlerPool = (MessageHandlerPool)BootstrapManager.this.contextBuilder.getCurrentContext().get("handlerPool");
                if (handlerPool == null) {
                    handlerPool = new MessageHandlerPool(BootstrapManager.this.agentTokenServices);
                    BootstrapManager.this.contextBuilder.getCurrentContext().put("handlerPool", handlerPool);
                }
                MessageHandler handler = handlerPool.get(handlerClass);
                return handler.handle(token, message);
            }
        });
    }

    public OutputMessage runBootstraped(AgentTokenWrapper token, InputMessage message) throws IOException, Exception {
        return this.runBootstraped(token, message, message.getHandler(), message.getHandlerPackage());
    }
}

