/*
 * Decompiled with CFR 0.152.
 */
package step.grid.contextbuilder;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassPathHelper {
    public static List<URL> forSingleFile(File file) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            ClassPathHelper.addFileToUrls(urls, file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting url list for file " + file.getAbsolutePath());
        }
        return urls;
    }

    public static List<URL> forAllJarsInFolderUsingFilter(final File folder, final FilenameFilter addtitionalFilter) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            ClassPathHelper.addFilesToUrls(urls, folder, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().endsWith(".jar") && (addtitionalFilter == null || addtitionalFilter.accept(folder, pathname.getName()));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting url list for directory " + folder.getAbsolutePath());
        }
        return urls;
    }

    public static List<URL> forAllJarsInFolder(File folder) {
        return ClassPathHelper.forAllJarsInFolderUsingFilter(folder, null);
    }

    public static List<URL> forClassPathString(String classPathString) throws MalformedURLException, IOException {
        String[] paths;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths = classPathString.split(";")) {
            File f = new File(path);
            ClassPathHelper.addFileToUrls(urls, f);
            urls.add(f.getCanonicalFile().toURI().toURL());
        }
        return urls;
    }

    private static void addFilesToUrls(List<URL> urls, File f, FileFilter filter) throws IOException {
        if (f.isDirectory()) {
            for (File file : f.listFiles(filter)) {
                ClassPathHelper.addFilesToUrls(urls, file, filter);
            }
        } else {
            ClassPathHelper.addFileToUrls(urls, f);
        }
    }

    private static void addFileToUrls(List<URL> urls, File f) throws IOException {
        urls.add(f.getCanonicalFile().toURI().toURL());
    }
}

