/*
 * Decompiled with CFR 0.152.
 */
package step.grid.contextbuilder;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.contextbuilder.ApplicationContextBuilderException;
import step.grid.contextbuilder.ApplicationContextFactory;
import step.grid.filemanager.FileProviderException;
import step.grid.io.InputMessage;

public class ApplicationContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextBuilder.class);
    private ApplicationContext rootContext;
    private ThreadLocal<ApplicationContext> currentContexts = new ThreadLocal();

    public ApplicationContextBuilder() {
        this.rootContext = new ApplicationContext();
        this.rootContext.classLoader = InputMessage.class.getClassLoader();
        this.resetContext();
    }

    public void resetContext() {
        this.currentContexts.set(this.rootContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushContext(ApplicationContextFactory descriptor) throws ApplicationContextBuilderException {
        ApplicationContextBuilder applicationContextBuilder = this;
        synchronized (applicationContextBuilder) {
            ApplicationContext context;
            ApplicationContext parentContext = this.currentContexts.get();
            if (parentContext == null) {
                parentContext = this.rootContext;
            }
            String contextKey = descriptor.getId();
            if (!parentContext.childContexts.containsKey(contextKey)) {
                context = new ApplicationContext();
                try {
                    this.buildClassLoader(descriptor, context, parentContext);
                }
                catch (FileProviderException e) {
                    throw new ApplicationContextBuilderException(e);
                }
                parentContext.childContexts.put(contextKey, context);
            } else {
                context = (ApplicationContext)parentContext.childContexts.get(contextKey);
                try {
                    if (descriptor.requiresReload()) {
                        this.buildClassLoader(descriptor, context, parentContext);
                        context.contextObjects.clear();
                    }
                }
                catch (FileProviderException e) {
                    throw new ApplicationContextBuilderException(e);
                }
            }
            this.currentContexts.set(context);
        }
    }

    private void buildClassLoader(ApplicationContextFactory descriptor, ApplicationContext context, ApplicationContext parentContext) throws FileProviderException {
        ClassLoader classLoader = descriptor.buildClassLoader(parentContext.classLoader);
        context.classLoader = classLoader;
    }

    public ApplicationContext getCurrentContext() {
        return this.currentContexts.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInContext(Callable<T> runnable) throws Exception {
        ClassLoader previousCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getCurrentContext().getClassLoader());
        try {
            T t = runnable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousCl);
        }
    }

    public static class ApplicationContext
    implements Closeable {
        private ClassLoader classLoader;
        private Map<String, ApplicationContext> childContexts = new ConcurrentHashMap<String, ApplicationContext>();
        private Map<String, Object> contextObjects = new HashMap<String, Object>();

        public Object get(Object key) {
            return this.contextObjects.get(key);
        }

        public Object put(String key, Object value) {
            return this.contextObjects.put(key, value);
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public void close() throws IOException {
            if (this.classLoader != null && this.classLoader instanceof Closeable) {
                ((Closeable)((Object)this.classLoader)).close();
            }
        }
    }
}

