/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent.handler;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.AgentContextAware;
import step.grid.agent.handler.MessageHandler;

public class MessageHandlerPool {
    private static final Logger logger = LoggerFactory.getLogger(MessageHandlerPool.class);
    private final AgentTokenServices tokenServices;
    private Map<String, MessageHandler> pool = new HashMap<String, MessageHandler>();

    public MessageHandlerPool(AgentTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public MessageHandler get(String handlerClassname) throws Exception {
        return this.get(handlerClassname, Thread.currentThread().getContextClassLoader());
    }

    public synchronized MessageHandler get(String handlerClassname, ClassLoader classLoader) throws Exception {
        MessageHandler handler = this.pool.get(handlerClassname);
        if (handler == null) {
            handler = this.createHandler(handlerClassname, classLoader);
            this.pool.put(handlerClassname, handler);
        }
        return handler;
    }

    private MessageHandler createHandler(String handlerClassname, ClassLoader classLoader) throws ReflectiveOperationException, MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> class_ = classLoader.loadClass(handlerClassname);
        MessageHandler handler = this.newInstance(class_);
        if (handler instanceof AgentContextAware && this.tokenServices != null) {
            ((AgentContextAware)((Object)handler)).init(this.tokenServices);
        }
        return handler;
    }

    private MessageHandler newInstance(Class<?> class_) throws InstantiationException, IllegalAccessException {
        Object o = class_.newInstance();
        if (o != null && o instanceof MessageHandler) {
            return (MessageHandler)o;
        }
        throw new RuntimeException("The class '" + class_.getName() + "' doesn't extend " + MessageHandler.class);
    }
}

