/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.AgentContextAware;
import step.grid.agent.handler.MessageHandler;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.InputMessage;

public abstract class AbstractMessageHandler
implements MessageHandler,
AgentContextAware {
    protected AgentTokenServices agentTokenServices;

    @Override
    public void init(AgentTokenServices agentTokenServices) {
        this.agentTokenServices = agentTokenServices;
    }

    protected FileManagerClient.FileVersion retrieveFileVersion(String properyName, Map<String, String> properties) throws IOException {
        FileManagerClient.FileVersionId fileVersionId = this.getFileVersionId(properyName, properties);
        return this.agentTokenServices.getFileManagerClient().requestFileVersion(fileVersionId.getFileId(), fileVersionId.getVersion());
    }

    protected FileManagerClient.FileVersionId getFileVersionId(String properyName, Map<String, String> properties) {
        String key = properyName + ".id";
        if (properties.containsKey(key)) {
            String transferFileId = properties.get(key);
            long transferFileVersion = Long.parseLong(properties.get(properyName + ".version"));
            return new FileManagerClient.FileVersionId(transferFileId, transferFileVersion);
        }
        return null;
    }

    protected Map<String, String> buildPropertyMap(AgentTokenWrapper token, InputMessage message) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (message.getProperties() != null) {
            properties.putAll(message.getProperties());
        }
        if (token.getProperties() != null) {
            properties.putAll(token.getProperties());
        }
        return properties;
    }
}

