/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent.tokenpool;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSession
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSession.class);
    protected Map<String, Object> sessionObjects = new HashMap<String, Object>();

    public Object get(String arg0) {
        return this.sessionObjects.get(arg0);
    }

    public <T> T get(Class<T> objectClass) {
        Object object = this.get(objectClass.getName());
        if (object != null) {
            if (objectClass.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            throw new RuntimeException("The object found is not an instance of " + objectClass.getName());
        }
        return null;
    }

    public void put(Object object) {
        this.put(object.getClass().getName(), object);
    }

    public Object put(String arg0, Object arg1) {
        Object previous = this.get(arg0);
        this.closeIfCloseable(arg0, previous);
        return this.sessionObjects.put(arg0, arg1);
    }

    private void closeIfCloseable(String arg0, Object previous) {
        if (previous != null && previous instanceof Closeable) {
            logger.debug("Attempted to replace session object with key '" + arg0 + "'. Closing previous object.");
            try {
                ((Closeable)previous).close();
            }
            catch (Exception e) {
                logger.error("Error while closing '" + arg0 + "' from session.", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        for (String key : this.sessionObjects.keySet()) {
            this.closeIfCloseable(key, this.sessionObjects.get(key));
        }
    }
}

