/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.helpers.FileHelper;
import step.grid.agent.ObjectMapperResolver;
import step.grid.agent.RegistrationMessage;
import step.grid.filemanager.ControllerCallException;
import step.grid.filemanager.ControllerCallTimeout;
import step.grid.filemanager.FileProviderException;
import step.grid.filemanager.StreamingFileProvider;

public class RegistrationClient
implements StreamingFileProvider {
    private final String registrationServer;
    private Client client;
    private static final Logger logger = LoggerFactory.getLogger(RegistrationClient.class);
    int connectionTimeout;
    int callTimeout;

    public RegistrationClient(String registrationServer, int connectionTimeout, int callTimeout) {
        this.registrationServer = registrationServer;
        this.client = ClientBuilder.newClient();
        this.client.register(ObjectMapperResolver.class);
        this.client.register(JacksonJsonProvider.class);
        this.callTimeout = callTimeout;
        this.connectionTimeout = connectionTimeout;
    }

    public void sendRegistrationMessage(RegistrationMessage message) {
        try {
            Response r = this.client.target(this.registrationServer + "/grid/register").request().property("jersey.config.client.readTimeout", (Object)this.callTimeout).property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout).post(Entity.entity((Object)message, (String)"application/json"));
            r.readEntity(String.class);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                logger.error("Unable to reach " + this.registrationServer + " for agent registration (java.net.ConnectException: " + e.getCause().getMessage() + ")");
            }
            logger.error("while registering tokens to " + this.registrationServer, (Throwable)e);
        }
    }

    public void close() {
        this.client.close();
    }

    public File saveFileTo(String fileHandle, File container) throws FileProviderException {
        try {
            Response response;
            try {
                response = this.client.target(this.registrationServer + "/grid/file/" + fileHandle).request().property("jersey.config.client.readTimeout", (Object)this.callTimeout).property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout).get();
            }
            catch (ProcessingException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof SocketTimeoutException) {
                    String causeMessage = cause.getMessage();
                    if (causeMessage.contains("Read timed out")) {
                        throw new ControllerCallTimeout((Throwable)e, (long)this.callTimeout);
                    }
                    throw new ControllerCallException((Throwable)e);
                }
                throw new ControllerCallException((Throwable)e);
            }
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new RuntimeException("Unexpected server error: " + error);
            }
            InputStream in = (InputStream)response.getEntity();
            boolean isDirectory = response.getHeaderString("content-disposition").contains("dir");
            Matcher m = Pattern.compile(".*filename = (.+?);.*").matcher(response.getHeaderString("content-disposition"));
            if (m.find()) {
                String filename = m.group(1);
                long t2 = System.currentTimeMillis();
                File file = new File(container + "/" + filename);
                if (isDirectory) {
                    FileHelper.extractFolder((InputStream)in, (File)file);
                } else {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                    FileHelper.copy((InputStream)in, (OutputStream)bos, (int)1024);
                    bos.close();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Uncompressed file " + fileHandle + " in " + (System.currentTimeMillis() - t2) + "ms to " + file.getAbsoluteFile());
                }
                return file;
            }
            throw new RuntimeException("Unable to find filename in header: " + response.getHeaderString("content-disposition"));
        }
        catch (Exception e) {
            throw new FileProviderException(fileHandle, (Throwable)e);
        }
    }
}

