/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.Token;
import step.grid.agent.Agent;
import step.grid.agent.tokenpool.AgentTokenPool;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.bootstrap.BootstrapManager;
import step.grid.contextbuilder.ApplicationContextBuilderException;
import step.grid.filemanager.ControllerCallTimeout;
import step.grid.filemanager.FileProviderException;
import step.grid.io.AgentError;
import step.grid.io.AgentErrorCode;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;

@Singleton
@Path(value="/")
public class AgentServices {
    private static final Logger logger = LoggerFactory.getLogger(AgentServices.class);
    @Inject
    Agent agent;
    final ExecutorService executor = Executors.newCachedThreadPool();
    AgentTokenPool tokenPool;
    BootstrapManager bootstrapManager;

    @PostConstruct
    public void init() {
        this.tokenPool = this.agent.getTokenPool();
        this.bootstrapManager = new BootstrapManager(this.agent.getAgentTokenServices(), true);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/token/{id}/process")
    public OutputMessage process(@PathParam(value="id") String tokenId, final InputMessage message) {
        try {
            final AgentTokenWrapper tokenWrapper = this.tokenPool.getTokenForExecution(tokenId);
            if (tokenWrapper != null) {
                if (tokenWrapper.isInUse()) {
                    logger.warn("Token with id=" + tokenWrapper.getUid() + " was already in use.");
                }
                final ExecutionContext context = new ExecutionContext();
                tokenWrapper.setInUse(true);
                Future<OutputMessage> future = this.executor.submit(new Callable<OutputMessage>(){

                    @Override
                    public OutputMessage call() throws Exception {
                        try {
                            context.t = Thread.currentThread();
                            AgentServices.this.agent.getAgentTokenServices().getApplicationContextBuilder().resetContext();
                            OutputMessage outputMessage = AgentServices.this.bootstrapManager.runBootstraped(tokenWrapper, message);
                            return outputMessage;
                        }
                        catch (ApplicationContextBuilderException e) {
                            OutputMessage outputMessage = AgentServices.this.handleContextBuilderError(message, e);
                            return outputMessage;
                        }
                        catch (Exception e) {
                            OutputMessage outputMessage = AgentServices.this.handleUnexpectedError(message, e);
                            return outputMessage;
                        }
                        finally {
                            tokenWrapper.setInUse(false);
                        }
                    }
                });
                try {
                    OutputMessage output = future.get(message.getCallTimeout(), TimeUnit.MILLISECONDS);
                    return output;
                }
                catch (TimeoutException e) {
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    int i = 0;
                    boolean interruptionSucceeded = false;
                    while (!interruptionSucceeded && i++ < 10) {
                        interruptionSucceeded = this.tryInterruption(tokenWrapper, context, attachments);
                    }
                    future.cancel(true);
                    if (!interruptionSucceeded) {
                        return this.newAgentErrorOutput(new AgentError(AgentErrorCode.TIMEOUT_REQUEST_NOT_INTERRUPTED), attachments.toArray(new Attachment[0]));
                    }
                    return this.newAgentErrorOutput(new AgentError(AgentErrorCode.TIMEOUT_REQUEST_INTERRUPTED), attachments.toArray(new Attachment[0]));
                }
            }
            return this.newAgentErrorOutput(new AgentError(AgentErrorCode.TOKEN_NOT_FOUND), new Attachment[0]);
        }
        catch (AgentTokenPool.InvalidTokenIdException e) {
            return this.newAgentErrorOutput(new AgentError(AgentErrorCode.TOKEN_NOT_FOUND), new Attachment[0]);
        }
        catch (Exception e) {
            return this.handleUnexpectedError(message, e);
        }
    }

    private boolean tryInterruption(AgentTokenWrapper tokenWrapper, ExecutionContext context, List<Attachment> attachments) throws InterruptedException {
        if (tokenWrapper.isInUse()) {
            if (context.t != null) {
                StackTraceElement[] stacktrace = context.t.getStackTrace();
                Attachment stacktraceAttachment = this.generateAttachmentForStacktrace("stacktrace_before_interruption.log", stacktrace);
                attachments.add(stacktraceAttachment);
                context.t.interrupt();
                Thread.sleep(10L);
                return !tokenWrapper.isInUse();
            }
            return false;
        }
        return true;
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/token/{id}/reserve")
    public void reserveToken(@PathParam(value="id") String tokenId) throws AgentTokenPool.InvalidTokenIdException {
        this.tokenPool.createTokenReservationSession(tokenId);
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/token/{id}/release")
    public void releaseToken(@PathParam(value="id") String tokenId) throws AgentTokenPool.InvalidTokenIdException {
        this.tokenPool.closeTokenReservationSession(tokenId);
    }

    protected OutputMessage handleContextBuilderError(InputMessage inputMessage, ApplicationContextBuilderException e) {
        AgentError error;
        Throwable cause = e.getCause();
        if (cause instanceof FileProviderException) {
            FileProviderException fileProviderException = (FileProviderException)cause;
            HashMap<AgentErrorCode.Details, String> details = new HashMap<AgentErrorCode.Details, String>();
            details.put(AgentErrorCode.Details.FILE_HANDLE, fileProviderException.getFileHandle());
            Throwable fileProviderExceptionCause = fileProviderException.getCause();
            if (fileProviderExceptionCause instanceof ControllerCallTimeout) {
                error = new AgentError(AgentErrorCode.CONTEXT_BUILDER_FILE_PROVIDER_CALL_TIMEOUT);
                details.put(AgentErrorCode.Details.TIMEOUT, Long.toString(((ControllerCallTimeout)fileProviderExceptionCause).getTimeout()));
                error.setErrorDetails(details);
            } else {
                error = new AgentError(AgentErrorCode.CONTEXT_BUILDER_FILE_PROVIDER_CALL_ERROR, details);
            }
        } else {
            error = new AgentError(AgentErrorCode.CONTEXT_BUILDER);
        }
        OutputMessage output = this.newAgentErrorOutput(error, new Attachment[0]);
        output.addAttachment(this.generateAttachmentForException(e));
        return output;
    }

    protected OutputMessage handleUnexpectedError(InputMessage inputMessage, Exception e) {
        OutputMessage output = this.newAgentErrorOutput(new AgentError(AgentErrorCode.UNEXPECTED), new Attachment[0]);
        output.addAttachment(this.generateAttachmentForException(e));
        return output;
    }

    protected OutputMessage newAgentErrorOutput(AgentError error, Attachment ... attachments) {
        OutputMessage output = new OutputMessage();
        output.setAgentError(error);
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                output.addAttachment(attachment);
            }
        }
        return output;
    }

    protected Attachment generateAttachmentForException(Throwable e) {
        Attachment attachment = new Attachment();
        attachment.setName("exception.log");
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        attachment.setHexContent(AttachmentHelper.getHex((byte[])w.toString().getBytes()));
        return attachment;
    }

    protected Attachment generateAttachmentForStacktrace(String attachmentName, StackTraceElement[] e) {
        Attachment attachment = new Attachment();
        StringWriter str = new StringWriter();
        PrintWriter w = new PrintWriter(str);
        for (StackTraceElement traceElement : e) {
            w.println("\tat " + traceElement);
        }
        attachment.setName(attachmentName);
        attachment.setHexContent(AttachmentHelper.getHex((byte[])str.toString().getBytes()));
        return attachment;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/token/list")
    public List<Token> listTokens() {
        return this.agent.getTokens();
    }

    class ExecutionContext {
        protected Thread t;

        ExecutionContext() {
        }
    }
}

