/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent;

import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.AgentRef;
import step.grid.agent.Agent;
import step.grid.agent.RegistrationClient;
import step.grid.agent.RegistrationMessage;

public class RegistrationTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationTask.class);
    private final Agent agent;
    private final RegistrationClient client;
    private boolean interrupted;

    public RegistrationTask(Agent agent, RegistrationClient client) {
        this.agent = agent;
        this.client = client;
    }

    @Override
    public void run() {
        if (!this.interrupted) {
            try {
                RegistrationMessage message = new RegistrationMessage(new AgentRef(this.agent.getId(), this.agent.getAgentUrl()), this.agent.getTokens());
                logger.debug("Sending registration message " + message.toString());
                this.client.sendRegistrationMessage(message);
            }
            catch (Exception e) {
                logger.error("An unexpected error occurred while registering the adapter.", (Throwable)e);
            }
        }
    }

    protected void interrupt() {
        this.interrupted = true;
    }

    protected void resume() {
        this.interrupted = false;
    }

    protected void unregister() {
    }

    protected void destroy() {
        this.client.close();
    }
}

