/*
 * Decompiled with CFR 0.152.
 */
package step.grid.filemanager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.helpers.FileHelper;
import step.grid.filemanager.FileManagerClient;
import step.grid.filemanager.FileProvider;

public class FileManagerClientImpl
implements FileManagerClient {
    private static final Logger logger = LoggerFactory.getLogger(FileManagerClientImpl.class);
    private File dataFolder;
    private FileProvider fileProvider;
    private Map<String, FileInfo> cache = new ConcurrentHashMap<String, FileInfo>();

    public String getDataFolderPath() {
        return this.dataFolder.getAbsolutePath();
    }

    public FileManagerClientImpl(File dataFolder, FileProvider fileProvider) {
        logger.info("Starting file manager client using data folder: " + dataFolder.getAbsolutePath());
        this.dataFolder = dataFolder;
        this.fileProvider = fileProvider;
        this.loadCache();
    }

    private void loadCache() {
        logger.info("Loading file manager client cache from data folder: " + this.dataFolder.getAbsolutePath());
        for (File file : this.dataFolder.listFiles()) {
            try {
                if (file.isDirectory()) {
                    for (File container : file.listFiles()) {
                        String fileId = file.getName();
                        String versionStr = container.getName();
                        if (container.isDirectory()) {
                            File[] containerFiles = container.listFiles();
                            if (containerFiles.length == 1) {
                                long version;
                                FileInfo fileInfo = this.cache.get(fileId);
                                if (fileInfo == null) {
                                    fileInfo = new FileInfo(fileId);
                                }
                                if (fileInfo.lastModified >= (version = Long.parseLong(versionStr))) continue;
                                fileInfo.lastModified = version;
                                fileInfo.file = containerFiles[0];
                                this.cache.put(fileId, fileInfo);
                                logger.debug("Adding file to cache. file id: " + fileId + " and version " + Long.toString(version));
                                continue;
                            }
                            throw new RuntimeException("The container " + container.getAbsolutePath() + " contains more than one file!");
                        }
                        throw new RuntimeException("The file " + container.getAbsolutePath() + " is not a directory!");
                    }
                    continue;
                }
                throw new RuntimeException("The file " + file.getAbsolutePath() + " is not a directory!");
            }
            catch (Exception e) {
                logger.error("Error while loading file manager client cache for file " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public File requestFile(String uid, long lastModified) {
        try {
            return this.requestFileVersion(uid, lastModified).getFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while requesting file " + uid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileManagerClient.FileVersion requestFileVersion(String uid, long lastModified) throws IOException {
        boolean fileModication;
        FileInfo currentValue;
        FileInfo fileInfo;
        FileManagerClient.FileVersion response = new FileManagerClient.FileVersion();
        response.setFileId(uid);
        if (logger.isDebugEnabled()) {
            logger.debug("Got file request for file id: " + uid + " and version " + Long.toString(lastModified));
        }
        if ((fileInfo = this.cache.get(uid)) == null && (currentValue = this.cache.putIfAbsent(uid, fileInfo = new FileInfo(uid))) != null) {
            fileInfo = currentValue;
        }
        FileInfo fileInfo2 = fileInfo;
        synchronized (fileInfo2) {
            if (fileInfo.file == null) {
                logger.info("Cache miss for file id: " + uid + " and version " + Long.toString(lastModified) + ". Requesting file from server");
                this.requestFileAndUpdateCache(fileInfo, uid, lastModified);
                fileModication = true;
            } else if (lastModified > fileInfo.lastModified) {
                logger.info("File version mismatch for file id: " + uid + " and version " + Long.toString(lastModified) + ". Requesting file from server");
                this.requestFileAndUpdateCache(fileInfo, uid, lastModified);
                fileModication = true;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Served file request from cache. file id: " + uid + " and version " + Long.toString(lastModified));
                }
                fileModication = false;
            }
        }
        response.setModified(fileModication);
        response.setVersion(lastModified);
        response.setFile(fileInfo.file);
        return response;
    }

    private void requestFileAndUpdateCache(FileInfo fileInfo, String uid, long lastModified) throws IOException {
        File file = this.requestControllerFile(uid, lastModified);
        this.updateFileInfo(fileInfo, file, lastModified);
    }

    private void updateFileInfo(FileInfo fileInfo, File file, long lastModified) {
        fileInfo.file = file;
        fileInfo.lastModified = lastModified;
    }

    private File requestControllerFile(String fileId, long lastModified) throws IOException {
        long t1 = System.currentTimeMillis();
        FileProvider.TransportableFile transportableFile = this.fileProvider.getTransportableFile(fileId);
        if (logger.isDebugEnabled()) {
            logger.debug("Got file " + fileId + " from server in " + (System.currentTimeMillis() - t1) + "ms.");
        }
        long t2 = System.currentTimeMillis();
        byte[] bytes = transportableFile.getBytes();
        File container = new File(this.dataFolder + "/" + fileId + "/" + lastModified);
        if (container.exists()) {
            FileHelper.deleteFolder((File)container);
        }
        container.mkdirs();
        FileHelper.deleteFolderOnExit((File)container);
        File file = new File(container + "/" + transportableFile.getName());
        if (transportableFile.isDirectory()) {
            FileHelper.extractFolder((byte[])bytes, (File)file);
        } else {
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                bos.write(bytes);
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Uncompressed file " + fileId + " in " + (System.currentTimeMillis() - t2) + "ms to " + file.getAbsoluteFile());
        }
        return file.getAbsoluteFile();
    }

    static class FileInfo {
        final String uid;
        File file;
        long lastModified;

        public FileInfo(String uid) {
            this.uid = uid;
        }
    }
}

