/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent.tokenpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.agent.tokenpool.TokenReservationSession;

public class AgentTokenPool {
    private static final Logger logger = LoggerFactory.getLogger(AgentTokenPool.class);
    private final Map<String, AgentTokenWrapper> pool = new HashMap<String, AgentTokenWrapper>();

    public synchronized List<AgentTokenWrapper> getTokens() {
        ArrayList<AgentTokenWrapper> result = new ArrayList<AgentTokenWrapper>(this.pool.size());
        result.addAll(this.pool.values());
        return result;
    }

    public synchronized void offerToken(AgentTokenWrapper token) {
        logger.debug("offerToken: " + token.toString());
        this.pool.put(token.getUid(), token);
    }

    public synchronized AgentTokenWrapper getTokenForExecution(String tokenId) throws InvalidTokenIdException {
        AgentTokenWrapper token = this.pool.get(tokenId);
        if (token != null) {
            if (token.getTokenReservationSession() == null) {
                token.setTokenReservationSession(new TokenReservationSession(){

                    @Override
                    public Object get(String arg0) {
                        throw this.unusableSessionException();
                    }

                    @Override
                    public Object put(String arg0, Object arg1) {
                        throw this.unusableSessionException();
                    }

                    private RuntimeException unusableSessionException() {
                        return new RuntimeException("Session object unreachable. Wrap your keywords with a Session node in your test plan in order to make the session object available.");
                    }
                });
            }
        } else {
            throw new InvalidTokenIdException();
        }
        return token;
    }

    private AgentTokenWrapper getToken(String tokenId) {
        AgentTokenWrapper token = this.pool.get(tokenId);
        return token;
    }

    public synchronized void createTokenReservationSession(String tokenId) throws InvalidTokenIdException {
        AgentTokenWrapper token = this.getToken(tokenId);
        if (token != null) {
            TokenReservationSession previousTokenReservationSession = token.getTokenReservationSession();
            if (previousTokenReservationSession != null) {
                logger.warn("Trying to reserve token '" + tokenId + "' which is already reserved. Closing previous session.");
                try {
                    previousTokenReservationSession.close();
                }
                catch (Exception e) {
                    logger.warn("Error while closing token session for token " + tokenId + ". This may cause a resource leak. Creating new session anyway.", (Throwable)e);
                }
            }
        } else {
            throw new InvalidTokenIdException();
        }
        TokenReservationSession tokenReservationContext = new TokenReservationSession();
        token.setTokenReservationSession(tokenReservationContext);
    }

    public synchronized void closeTokenReservationSession(String tokenId) throws InvalidTokenIdException {
        AgentTokenWrapper token = this.getToken(tokenId);
        if (token != null) {
            TokenReservationSession tokenReservationSession = token.getTokenReservationSession();
            token.setTokenReservationSession(null);
            if (tokenReservationSession != null) {
                try {
                    tokenReservationSession.close();
                }
                catch (Exception e) {
                    logger.warn("Error while closing token session for token " + tokenId + ". This may cause a resource leak. Still returning token to the pool.", (Throwable)e);
                }
            } else {
                logger.warn("Trying to release token '" + tokenId + "' which is not reserved");
            }
        } else {
            throw new InvalidTokenIdException();
        }
    }

    public static class InvalidTokenIdException
    extends Exception {
    }
}

