/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.agent.ObjectMapperResolver;
import step.grid.agent.RegistrationMessage;
import step.grid.filemanager.FileProvider;

public class RegistrationClient
implements FileProvider {
    private final String registrationServer;
    private Client client;
    private static final Logger logger = LoggerFactory.getLogger(RegistrationClient.class);
    int connectionTimeout;
    int callTimeout;

    public RegistrationClient(String registrationServer, int connectionTimeout, int callTimeout) {
        this.registrationServer = registrationServer;
        this.client = ClientBuilder.newClient();
        this.client.register(ObjectMapperResolver.class);
        this.client.register(JacksonJsonProvider.class);
        this.callTimeout = callTimeout;
        this.connectionTimeout = connectionTimeout;
    }

    public void sendRegistrationMessage(RegistrationMessage message) {
        try {
            Response r = this.client.target(this.registrationServer + "/grid/register").request().property("jersey.config.client.readTimeout", (Object)this.callTimeout).property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout).post(Entity.entity((Object)message, (String)"application/json"));
            r.readEntity(String.class);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                logger.error("Unable to reach " + this.registrationServer + " for agent registration (java.net.ConnectException: " + e.getCause().getMessage() + ")");
            }
            logger.error("while registering tokens to " + this.registrationServer, (Throwable)e);
        }
    }

    public void close() {
        this.client.close();
    }

    public FileProvider.TransportableFile getTransportableFile(String fileId) throws IOException {
        Response response = this.client.target(this.registrationServer + "/grid/file/" + fileId).request().property("jersey.config.client.readTimeout", (Object)this.callTimeout).property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout).get();
        InputStream in = (InputStream)response.getEntity();
        byte[] bytes = ByteStreams.toByteArray((InputStream)in);
        boolean isDirectory = response.getHeaderString("content-disposition").contains("dir");
        Matcher m = Pattern.compile(".*filename = (.+?);.*").matcher(response.getHeaderString("content-disposition"));
        if (m.find()) {
            String filename = m.group(1);
            return new FileProvider.TransportableFile(filename, isDirectory, bytes);
        }
        throw new RuntimeException("Unable to find filename in header: " + response.getHeaderString("content-disposition"));
    }
}

