/*
 * Decompiled with CFR 0.152.
 */
package step.grid.agent;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.Token;
import step.grid.agent.AgentServices;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.ArgumentParser;
import step.grid.agent.ObjectMapperResolver;
import step.grid.agent.RegistrationClient;
import step.grid.agent.RegistrationTask;
import step.grid.agent.conf.AgentConf;
import step.grid.agent.conf.AgentConfParser;
import step.grid.agent.conf.TokenConf;
import step.grid.agent.conf.TokenGroupConf;
import step.grid.agent.tokenpool.AgentTokenPool;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.filemanager.FileManagerClient;
import step.grid.filemanager.FileManagerClientImpl;
import step.grid.tokenpool.Interest;

public class Agent {
    private static final Logger logger = LoggerFactory.getLogger(Agent.class);
    public static final String AGENT_TYPE_KEY = "$agenttype";
    private String id;
    private AgentConf agentConf;
    private Server server;
    private AgentTokenPool tokenPool;
    private Timer timer;
    private RegistrationTask registrationTask;
    private AgentTokenServices agentTokenServices;

    public Agent(String[] args) throws Exception {
        AgentConf agentConf;
        ArgumentParser arguments = new ArgumentParser(args);
        String agentConfStr = arguments.getOption("config");
        if (agentConfStr != null) {
            AgentConfParser parser = new AgentConfParser();
            agentConf = parser.parser(new File(agentConfStr));
            if (arguments.hasOption("gridHost")) {
                agentConf.setGridHost(arguments.getOption("gridHost"));
            }
            if (arguments.hasOption("agentPort")) {
                agentConf.setAgentPort(Integer.decode(arguments.getOption("agentPort")));
            } else if (agentConf.getAgentPort() == null) {
                agentConf.setAgentPort(0);
            }
            if (arguments.hasOption("agentHost")) {
                agentConf.setAgentHost(arguments.getOption("agentHost"));
            }
            if (arguments.hasOption("agentUrl")) {
                agentConf.setAgentUrl(arguments.getOption("agentUrl"));
            }
        } else {
            throw new RuntimeException("Argument '-config' is missing.");
        }
        this.agentConf = agentConf;
        this.id = UUID.randomUUID().toString();
        this.tokenPool = new AgentTokenPool();
        this.start();
    }

    public Agent(AgentConf agentConf) throws Exception {
        this.agentConf = agentConf;
        this.id = UUID.randomUUID().toString();
        this.tokenPool = new AgentTokenPool();
    }

    public String getId() {
        return this.id;
    }

    public void addTokens(int count, Map<String, String> attributes, Map<String, String> selectionPatterns, Map<String, String> properties) {
        for (int i = 0; i < count; ++i) {
            AgentTokenWrapper token = new AgentTokenWrapper();
            token.getToken().setAgentid(this.id);
            HashMap<String, String> allAttributes = new HashMap<String, String>();
            allAttributes.putAll(attributes);
            allAttributes.put(AGENT_TYPE_KEY, "default");
            token.setAttributes(allAttributes);
            token.setSelectionPatterns(this.createInterestMap(selectionPatterns));
            token.setProperties(properties);
            token.setServices(this.agentTokenServices);
            this.tokenPool.offerToken(token);
        }
    }

    private Map<String, Interest> createInterestMap(Map<String, String> selectionPatterns) {
        HashMap<String, Interest> result = new HashMap<String, Interest>();
        if (selectionPatterns != null) {
            for (Map.Entry<String, String> entry : selectionPatterns.entrySet()) {
                Interest i = new Interest(Pattern.compile(entry.getValue()), true);
                result.put(entry.getKey(), i);
            }
        }
        return result;
    }

    public void start() throws Exception {
        final Agent agent = this;
        AgentConf agentConf = agent.agentConf;
        RegistrationClient registrationClient = new RegistrationClient(agent.getGridHost(), agentConf.getGridConnectTimeout(), agentConf.getGridReadTimeout());
        FileManagerClient fileManagerClient = this.initFileManager(registrationClient);
        this.agentTokenServices = new AgentTokenServices(fileManagerClient);
        this.agentTokenServices.setAgentProperties(agentConf.getProperties());
        this.agentTokenServices.setApplicationContextBuilder(new ApplicationContextBuilder());
        if (agentConf.getTokenGroups() != null) {
            for (TokenGroupConf group : agentConf.getTokenGroups()) {
                TokenConf tokenConf = group.getTokenConf();
                this.addTokens(group.getCapacity(), tokenConf.getAttributes(), tokenConf.getSelectionPatterns(), tokenConf.getProperties());
            }
        }
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.packages(new String[]{AgentServices.class.getPackage().getName()});
        resourceConfig.register(JacksonJsonProvider.class);
        resourceConfig.register(ObjectMapperResolver.class);
        resourceConfig.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(agent).to(Agent.class);
            }
        });
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder sh = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(sh, "/*");
        this.server = new Server(agentConf.getAgentPort().intValue());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{context});
        this.server.setHandler((Handler)contexts);
        this.timer = new Timer();
        this.registrationTask = new RegistrationTask(this, registrationClient);
        this.server.start();
        if (agentConf.getAgentUrl() == null) {
            if (agentConf.getAgentHost() == null) {
                agentConf.setAgentUrl("http://" + Inet4Address.getLocalHost().getCanonicalHostName() + ":" + ((ServerConnector)this.server.getConnectors()[0]).getLocalPort());
            } else {
                agentConf.setAgentUrl("http://" + agentConf.getAgentHost() + ":" + ((ServerConnector)this.server.getConnectors()[0]).getLocalPort());
            }
        }
        this.timer.schedule((TimerTask)this.registrationTask, 0L, (long)agentConf.getRegistrationPeriod().intValue());
    }

    private FileManagerClient initFileManager(RegistrationClient registrationClient) throws IOException {
        String workingDir = this.agentConf.getWorkingDir();
        String fileManagerDirPath = workingDir != null ? workingDir : ".";
        File fileManagerDir = new File(fileManagerDirPath = fileManagerDirPath + "/filemanager");
        if (!fileManagerDir.exists()) {
            Files.createDirectories(fileManagerDir.toPath(), new FileAttribute[0]);
        }
        FileManagerClientImpl fileManagerClient = new FileManagerClientImpl(fileManagerDir, registrationClient);
        return fileManagerClient;
    }

    protected String getAgentUrl() {
        return this.agentConf.getAgentUrl();
    }

    public void stop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.registrationTask != null) {
            this.registrationTask.cancel();
            this.registrationTask.unregister();
            this.registrationTask.destroy();
        }
        this.server.stop();
    }

    protected AgentTokenPool getTokenPool() {
        return this.tokenPool;
    }

    protected RegistrationTask getRegistrationTask() {
        return this.registrationTask;
    }

    public AgentTokenServices getAgentTokenServices() {
        return this.agentTokenServices;
    }

    protected List<Token> getTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (AgentTokenWrapper wrapper : this.tokenPool.getTokens()) {
            tokens.add(wrapper.getToken());
        }
        return tokens;
    }

    protected List<Token> getAvailableTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (AgentTokenWrapper wrapper : this.tokenPool.getTokens()) {
            if (wrapper.isInUse()) continue;
            tokens.add(wrapper.getToken());
        }
        return tokens;
    }

    protected String getGridHost() {
        return this.agentConf.getGridHost();
    }
}

