/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.attachments.FileResolver;
import step.commons.conf.Configuration;
import step.core.GlobalContext;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.core.dynamicbeans.DynamicJsonValueResolver;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.functions.accessor.FunctionAccessor;
import step.functions.accessor.FunctionAccessorImpl;
import step.functions.accessor.FunctionCRUDAccessor;
import step.functions.accessor.InMemoryFunctionAccessorImpl;
import step.functions.editors.FunctionEditorRegistry;
import step.functions.execution.ConfigurableTokenLifecycleStrategy;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceImpl;
import step.functions.manager.FunctionManager;
import step.functions.manager.FunctionManagerImpl;
import step.functions.routing.FunctionRouter;
import step.functions.type.FunctionTypeRegistry;
import step.functions.type.FunctionTypeRegistryImpl;
import step.grid.Grid;
import step.grid.GridFileService;
import step.grid.client.GridClient;
import step.grid.client.GridClientConfiguration;
import step.grid.client.GridClientImpl;
import step.grid.client.TokenLifecycleStrategy;
import step.grid.io.AgentErrorCode;
import step.grid.tokenpool.TokenRegistry;
import step.plugins.adaptergrid.FunctionServices;
import step.plugins.adaptergrid.GridServices;

@Plugin
public class GridPlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(GridPlugin.class);
    private Grid grid;
    private GridClient client;
    private FunctionEditorRegistry editorRegistry;
    private FunctionTypeRegistry functionTypeRegistry;
    private FunctionCRUDAccessor functionAccessor;
    private FunctionManager functionManager;
    private FunctionExecutionService functionExecutionService;
    private FunctionRouter functionRouter;

    public void executionControllerStart(GlobalContext context) throws Exception {
        Configuration configuration = context.getConfiguration();
        Integer gridPort = configuration.getPropertyAsInteger("grid.port", Integer.valueOf(8081));
        Integer tokenTTL = configuration.getPropertyAsInteger("grid.ttl", Integer.valueOf(60000));
        this.grid = new Grid(gridPort, tokenTTL);
        this.grid.start();
        ConfigurableTokenLifecycleStrategy tokenLifecycleStrategy = this.getTokenLifecycleStrategy(configuration);
        GridClientConfiguration gridClientConfiguration = this.buildGridClientConfiguration(configuration);
        this.client = new GridClientImpl(gridClientConfiguration, (TokenRegistry)this.grid, (TokenLifecycleStrategy)tokenLifecycleStrategy, (GridFileService)this.grid);
        this.editorRegistry = new FunctionEditorRegistry();
        this.functionTypeRegistry = new FunctionTypeRegistryImpl(new FileResolver(context.getAttachmentManager()), (GridFileService)this.grid);
        this.functionAccessor = new FunctionAccessorImpl(context.getMongoClientSession());
        this.functionManager = new FunctionManagerImpl(this.functionAccessor, this.functionTypeRegistry);
        this.functionExecutionService = new FunctionExecutionServiceImpl(this.client, (FunctionAccessor)this.functionAccessor, this.functionTypeRegistry, context.getDynamicBeanResolver());
        DynamicJsonObjectResolver dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(context.getExpressionHandler()));
        this.functionRouter = new FunctionRouter(this.functionExecutionService, this.functionTypeRegistry, dynamicJsonObjectResolver);
        context.put(Grid.class, (Object)this.grid);
        context.put(FunctionAccessor.class, (Object)this.functionAccessor);
        context.put(FunctionManager.class, (Object)this.functionManager);
        context.put(FunctionTypeRegistry.class, (Object)this.functionTypeRegistry);
        context.put(FunctionEditorRegistry.class, (Object)this.editorRegistry);
        context.put(FunctionExecutionService.class, (Object)this.functionExecutionService);
        context.put(FunctionRouter.class, (Object)this.functionRouter);
        context.getServiceRegistrationCallback().registerService(GridServices.class);
        context.getServiceRegistrationCallback().registerService(FunctionServices.class);
    }

    protected ConfigurableTokenLifecycleStrategy getTokenLifecycleStrategy(Configuration configuration) {
        return new ConfigurableTokenLifecycleStrategy(configuration.getPropertyAsBoolean("grid.client.token.lifecycle.remove.on.tokenreleaseerror", true), configuration.getPropertyAsBoolean("grid.client.token.lifecycle.remove.on.tokenreservationerror", true), configuration.getPropertyAsBoolean("grid.client.token.lifecycle.remove.on.tokencallerror", true), configuration.getPropertyAsBoolean("grid.client.token.lifecycle.remove.on.agenterror", true), Arrays.asList(configuration.getProperty("grid.client.token.lifecycle.remove.on.agenterrors", AgentErrorCode.TIMEOUT_REQUEST_NOT_INTERRUPTED.toString()).split(",")).stream().map(v -> AgentErrorCode.valueOf((String)v)).collect(Collectors.toSet()));
    }

    protected GridClientConfiguration buildGridClientConfiguration(Configuration configuration) {
        GridClientConfiguration gridClientConfiguration = new GridClientConfiguration();
        gridClientConfiguration.setNoMatchExistsTimeout(configuration.getPropertyAsLong("grid.client.token.selection.nomatch.timeout.ms", Long.valueOf(gridClientConfiguration.getNoMatchExistsTimeout())).longValue());
        gridClientConfiguration.setMatchExistsTimeout(configuration.getPropertyAsLong("grid.client.token.selection.matchexist.timeout.ms", Long.valueOf(gridClientConfiguration.getMatchExistsTimeout())).longValue());
        gridClientConfiguration.setReadTimeoutOffset(configuration.getPropertyAsInteger("grid.client.token.call.readtimeout.offset.ms", Integer.valueOf(gridClientConfiguration.getReadTimeoutOffset())).intValue());
        gridClientConfiguration.setReserveSessionTimeout(configuration.getPropertyAsInteger("grid.client.token.reserve.timeout.ms", Integer.valueOf(gridClientConfiguration.getReserveSessionTimeout())).intValue());
        gridClientConfiguration.setReleaseSessionTimeout(configuration.getPropertyAsInteger("grid.client.token.release.timeout.ms", Integer.valueOf(gridClientConfiguration.getReleaseSessionTimeout())).intValue());
        return gridClientConfiguration;
    }

    public void executionStart(ExecutionContext context) {
        boolean isolatedExecution = context.getExecutionParameters().isIsolatedExecution();
        if (isolatedExecution) {
            InMemoryFunctionAccessorImpl functionAccessor = new InMemoryFunctionAccessorImpl();
            FunctionExecutionServiceImpl functionExecutionService = new FunctionExecutionServiceImpl(this.client, (FunctionAccessor)functionAccessor, this.functionTypeRegistry, context.getDynamicBeanResolver());
            DynamicJsonObjectResolver dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(context.getExpressionHandler()));
            FunctionRouter functionRouter = new FunctionRouter(functionExecutionService, this.functionTypeRegistry, dynamicJsonObjectResolver);
            context.put(FunctionAccessor.class, (Object)functionAccessor);
            context.put(FunctionExecutionService.class, (Object)functionExecutionService);
            context.put(FunctionRouter.class.getName(), (Object)functionRouter);
        } else {
            context.put(FunctionAccessor.class, (Object)this.functionAccessor);
            context.put(FunctionExecutionService.class, (Object)this.functionExecutionService);
            context.put(FunctionRouter.class.getName(), (Object)this.functionRouter);
        }
        super.executionStart(context);
    }

    public void executionControllerDestroy(GlobalContext context) {
        if (this.client != null) {
            this.client.close();
        }
        if (this.grid != null) {
            try {
                this.grid.stop();
            }
            catch (Exception e) {
                logger.error("Error while stopping the grid server", (Throwable)e);
            }
        }
    }
}

