/*
 * Decompiled with CFR 0.152.
 */
package step.functions.routing;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import step.artefacts.CallFunction;
import step.artefacts.handlers.FunctionGroupHandler;
import step.artefacts.handlers.TokenSelectorHelper;
import step.common.managedoperations.OperationManager;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.functions.Function;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistry;
import step.grid.TokenWrapper;
import step.grid.tokenpool.Interest;

public class FunctionRouter {
    protected final TokenSelectorHelper tokenSelectorHelper;
    protected final FunctionExecutionService functionExecutionService;
    protected final FunctionTypeRegistry functionTypeRegistry;
    private static final String ROUTE_TO = "route_to_";

    public FunctionRouter(FunctionExecutionService functionClient, FunctionTypeRegistry functionTypeRegistry, DynamicJsonObjectResolver dynamicJsonObjectResolver) {
        this.functionExecutionService = functionClient;
        this.functionTypeRegistry = functionTypeRegistry;
        this.tokenSelectorHelper = new TokenSelectorHelper(dynamicJsonObjectResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenWrapper selectToken(CallFunction callFunction, Function function, FunctionGroupHandler.FunctionGroupContext functionGroupContext, Map<String, Object> bindings) throws FunctionExecutionServiceException {
        TokenWrapper token;
        if (function.requiresLocalExecution()) {
            token = this.functionExecutionService.getLocalTokenHandle();
        } else if (functionGroupContext != null) {
            FunctionGroupHandler.FunctionGroupContext functionGroupContext2 = functionGroupContext;
            synchronized (functionGroupContext2) {
                if (functionGroupContext.getToken() != null) {
                    token = functionGroupContext.getToken();
                } else {
                    Map<String, Interest> selectionCriteria = this.buildSelectionCriteriaMap(callFunction, function, functionGroupContext, bindings);
                    token = this.selectToken(selectionCriteria, true);
                    functionGroupContext.setToken(token);
                }
            }
        } else {
            Map<String, Interest> selectionCriteria = this.buildSelectionCriteriaMap(callFunction, function, functionGroupContext, bindings);
            token = this.selectToken(selectionCriteria, false);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenWrapper selectToken(Map<String, Interest> selectionCriteria, boolean createSession) throws FunctionExecutionServiceException {
        TokenWrapper token;
        HashMap<String, String> pretenderAttributes = new HashMap<String, String>();
        OperationManager.getInstance().enter("Token selection", selectionCriteria);
        try {
            token = this.functionExecutionService.getTokenHandle(pretenderAttributes, selectionCriteria, createSession);
        }
        finally {
            OperationManager.getInstance().exit();
        }
        return token;
    }

    protected Map<String, Interest> buildSelectionCriteriaMap(CallFunction callFunction, Function function, FunctionGroupHandler.FunctionGroupContext functionGroupContext, Map<String, Object> bindings) {
        Map tokenSelectionCriteriaFromFunction;
        AbstractFunctionType<Function> functionType;
        Map<String, Interest> tokenSelectionCriteriaFromFunctionType;
        HashMap<String, Interest> selectionCriteria = new HashMap<String, Interest>();
        selectionCriteria.putAll(this.tokenSelectorHelper.getTokenSelectionCriteria(callFunction, bindings));
        if (functionGroupContext != null && functionGroupContext.getAdditionalSelectionCriteria() != null) {
            selectionCriteria.putAll(functionGroupContext.getAdditionalSelectionCriteria());
        }
        if (this.functionTypeRegistry != null && (tokenSelectionCriteriaFromFunctionType = (functionType = this.functionTypeRegistry.getFunctionTypeByFunction(function)).getTokenSelectionCriteria(function)) != null) {
            selectionCriteria.putAll(tokenSelectionCriteriaFromFunctionType);
        }
        if ((tokenSelectionCriteriaFromFunction = function.getTokenSelectionCriteria()) != null) {
            tokenSelectionCriteriaFromFunction.keySet().stream().forEach(key -> selectionCriteria.put((String)key, new Interest(Pattern.compile((String)tokenSelectionCriteriaFromFunction.get(key)), true)));
        }
        this.addTokenSelectionCriteriaFromBindings(selectionCriteria, bindings);
        return selectionCriteria;
    }

    private Map<String, Interest> addTokenSelectionCriteriaFromBindings(Map<String, Interest> addtionalSelectionCriteria, Map<String, Object> bindings) {
        bindings.forEach((k, v) -> {
            if (k.startsWith(ROUTE_TO)) {
                Pattern selectionPattern = Pattern.compile(v.toString());
                addtionalSelectionCriteria.put(k.replaceFirst(ROUTE_TO, ""), new Interest(selectionPattern, true));
            }
        });
        return addtionalSelectionCriteria;
    }
}

