/*
 * Decompiled with CFR 0.152.
 */
package step.functions.execution;

import java.util.Set;
import step.grid.TokenWrapper;
import step.grid.client.TokenLifecycleStrategy;
import step.grid.client.TokenLifecycleStrategyCallback;
import step.grid.io.AgentErrorCode;
import step.grid.io.OutputMessage;

public class ConfigurableTokenLifecycleStrategy
implements TokenLifecycleStrategy {
    private boolean addErrorOnTokenReleaseError = true;
    private boolean addErrorOnTokenReservationError = true;
    private boolean addErrorOnTokenCallError = true;
    private boolean addErrorOnAgentError = true;
    private Set<AgentErrorCode> concernedAgentErrors;

    public ConfigurableTokenLifecycleStrategy(boolean addErrorOnTokenReleaseError, boolean addErrorOnTokenReservationError, boolean addErrorOnTokenCallError, boolean addErrorOnAgentError, Set<AgentErrorCode> concernedAgentErrors) {
        this.addErrorOnTokenReleaseError = addErrorOnTokenReleaseError;
        this.addErrorOnTokenReservationError = addErrorOnTokenReservationError;
        this.addErrorOnTokenCallError = addErrorOnTokenCallError;
        this.addErrorOnAgentError = addErrorOnAgentError;
        this.concernedAgentErrors = concernedAgentErrors;
    }

    public boolean isAddErrorOnTokenReleaseError() {
        return this.addErrorOnTokenReleaseError;
    }

    public void setAddErrorOnTokenReleaseError(boolean addErrorOnTokenReleaseError) {
        this.addErrorOnTokenReleaseError = addErrorOnTokenReleaseError;
    }

    public boolean isAddErrorOnTokenReservationError() {
        return this.addErrorOnTokenReservationError;
    }

    public void setAddErrorOnTokenReservationError(boolean addErrorOnTokenReservationError) {
        this.addErrorOnTokenReservationError = addErrorOnTokenReservationError;
    }

    public boolean isAddErrorOnTokenCallError() {
        return this.addErrorOnTokenCallError;
    }

    public void setAddErrorOnTokenCallError(boolean addErrorOnTokenCallError) {
        this.addErrorOnTokenCallError = addErrorOnTokenCallError;
    }

    public boolean isAddErrorOnAgentError() {
        return this.addErrorOnAgentError;
    }

    public void setAddErrorOnAgentError(boolean addErrorOnAgentError) {
        this.addErrorOnAgentError = addErrorOnAgentError;
    }

    public Set<AgentErrorCode> getConcernedAgentErrors() {
        return this.concernedAgentErrors;
    }

    public void setConcernedAgentErrors(Set<AgentErrorCode> concernedAgentErrors) {
        this.concernedAgentErrors = concernedAgentErrors;
    }

    public void afterTokenReleaseError(TokenLifecycleStrategyCallback callback, TokenWrapper tokenWrapper, Exception e) {
        if (this.addErrorOnTokenReleaseError) {
            callback.addTokenError("Error while releasing token", e);
        }
    }

    public void afterTokenReservationError(TokenLifecycleStrategyCallback callback, TokenWrapper tokenWrapper, Exception e) {
        if (this.addErrorOnTokenReservationError) {
            callback.addTokenError("Error while reserving token", e);
        }
    }

    public void afterTokenCallError(TokenLifecycleStrategyCallback callback, TokenWrapper tokenWrapper, Exception e) {
        if (this.addErrorOnTokenCallError) {
            callback.addTokenError("Error while calling agent", e);
        }
    }

    public void afterTokenCall(TokenLifecycleStrategyCallback callback, TokenWrapper tokenWrapper, OutputMessage outputMessage) {
        if (this.addErrorOnAgentError && outputMessage != null && outputMessage.getAgentError() != null && (this.concernedAgentErrors == null || this.concernedAgentErrors.isEmpty() || this.concernedAgentErrors.contains(outputMessage.getAgentError().getErrorCode()))) {
            callback.addTokenError("Error while calling agent", null);
        }
    }
}

