/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.grid.AgentRef;
import step.grid.Grid;
import step.grid.GridReportBuilder;
import step.grid.TokenWrapper;
import step.grid.TokenWrapperState;
import step.grid.reports.TokenGroupCapacity;
import step.plugins.adaptergrid.AgentListEntry;

@Path(value="/grid")
public class GridServices
extends AbstractServices {
    protected Grid grid;

    @PostConstruct
    public void init() {
        this.grid = (Grid)this.getContext().get(Grid.class);
    }

    private GridReportBuilder getReportBuilder() {
        return new GridReportBuilder(this.grid);
    }

    @GET
    @Path(value="/agent")
    @Produces(value={"application/json"})
    public Collection<AgentListEntry> getAgents() {
        ArrayList<AgentListEntry> agents = new ArrayList<AgentListEntry>();
        this.grid.getAgents().forEach(agent -> {
            AgentListEntry agentState = new AgentListEntry();
            agentState.setAgentRef((AgentRef)agent);
            agentState.setTokens(this.getAgentTokens(agent.getAgentId()));
            agentState.setTokensCapacity(this.getTokensCapacity(agentState.getTokens()));
            agents.add(agentState);
        });
        return agents;
    }

    protected List<TokenWrapper> getAgentTokens(String agentId) {
        ArrayList<TokenWrapper> agentTokens = new ArrayList<TokenWrapper>();
        this.grid.getTokens().forEach(token -> {
            if (agentId.equals(((TokenWrapper)token.getObject()).getAgent().getAgentId())) {
                agentTokens.add((TokenWrapper)token.getObject());
            }
        });
        return agentTokens;
    }

    protected TokenGroupCapacity getTokensCapacity(List<TokenWrapper> tokens) {
        TokenGroupCapacity tokenGroup = new TokenGroupCapacity(new HashMap());
        HashMap stateDistribution = new HashMap();
        Arrays.asList(TokenWrapperState.values()).forEach(s -> stateDistribution.put(s, new AtomicInteger(0)));
        tokens.forEach(token -> {
            tokenGroup.incrementCapacity();
            ((AtomicInteger)stateDistribution.get(token.getState())).incrementAndGet();
        });
        HashMap result = new HashMap();
        stateDistribution.entrySet().forEach(e -> result.put(e.getKey(), ((AtomicInteger)e.getValue()).get()));
        tokenGroup.setCountByState(result);
        return tokenGroup;
    }

    @PUT
    @Secured(right="token-manage")
    @Path(value="/agent/{id}/interrupt")
    @Produces(value={"application/json"})
    public void interruptAgent(@PathParam(value="id") String agentId) {
        this.grid.getTokens().forEach(token -> {
            if (agentId.equals(((TokenWrapper)token.getObject()).getAgent().getAgentId())) {
                this.grid.startTokenMaintenance(((TokenWrapper)token.getObject()).getID());
            }
        });
    }

    @PUT
    @Secured(right="token-manage")
    @Path(value="/agent/{id}/resume")
    @Produces(value={"application/json"})
    public void resumeAgent(@PathParam(value="id") String agentId) {
        this.grid.getTokens().forEach(token -> {
            if (agentId.equals(((TokenWrapper)token.getObject()).getAgent().getAgentId())) {
                this.grid.stopTokenMaintenance(((TokenWrapper)token.getObject()).getID());
            }
        });
    }

    @DELETE
    @Secured(right="token-manage")
    @Path(value="/agent/{id}/tokens/errors")
    @Produces(value={"application/json"})
    public void removeAgentTokenErrors(@PathParam(value="id") String agentId) {
        this.grid.getTokens().forEach(token -> {
            if (((TokenWrapper)token.getObject()).getState().equals((Object)TokenWrapperState.ERROR)) {
                this.grid.removeTokenError(((TokenWrapper)token.getObject()).getID());
            }
        });
    }

    @GET
    @Path(value="/token")
    @Produces(value={"application/json"})
    public List<TokenWrapper> getTokenAssociations() {
        return this.getReportBuilder().getTokenAssociations(false);
    }

    @DELETE
    @Secured(right="token-manage")
    @Path(value="/token/{id}/error")
    @Consumes(value={"application/json"})
    public void removeTokenError(@PathParam(value="id") String tokenId) {
        this.grid.removeTokenError(tokenId);
    }

    @POST
    @Secured(right="token-manage")
    @Path(value="/token/{id}/maintenance")
    @Consumes(value={"application/json"})
    public void startTokenMaintenance(@PathParam(value="id") String tokenId) {
        this.grid.startTokenMaintenance(tokenId);
    }

    @DELETE
    @Secured(right="token-manage")
    @Path(value="/token/{id}/maintenance")
    @Consumes(value={"application/json"})
    public void stopTokenMaintenance(@PathParam(value="id") String tokenId) {
        this.grid.stopTokenMaintenance(tokenId);
    }

    @GET
    @Path(value="/token/usage")
    @Produces(value={"application/json"})
    public List<TokenGroupCapacity> getUsageByIdentity(@QueryParam(value="groupby") List<String> groupbys) {
        return this.getReportBuilder().getUsageByIdentity(groupbys);
    }

    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    public Set<String> getTokenAttributeKeys() {
        return this.getReportBuilder().getTokenAttributeKeys();
    }
}

