/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.json.Json;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.miscellaneous.ReportNodeAttachmentManager;
import step.functions.Function;
import step.functions.Input;
import step.functions.Output;
import step.functions.editors.FunctionEditor;
import step.functions.editors.FunctionEditorRegistry;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.manager.FunctionManager;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.grid.TokenWrapper;
import step.grid.tokenpool.Interest;

@Path(value="/functions")
public class FunctionServices
extends AbstractServices {
    protected ReportNodeAttachmentManager reportNodeAttachmentManager;
    protected FunctionManager functionManager;
    protected FunctionExecutionService functionExecutionService;

    @PostConstruct
    public void init() {
        this.reportNodeAttachmentManager = new ReportNodeAttachmentManager(this.getContext().getAttachmentManager());
        this.functionManager = (FunctionManager)this.getContext().get(FunctionManager.class);
        this.functionExecutionService = (FunctionExecutionService)this.getContext().get(FunctionExecutionService.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    @Secured(right="kw-write")
    public Function save(Function function) throws SetupFunctionException, FunctionTypeException {
        return this.functionManager.saveFunction(function);
    }

    @POST
    @Path(value="/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="kw-write")
    public void copyFunction(@PathParam(value="id") String id) throws FunctionTypeException {
        this.functionManager.copyFunction(id);
    }

    @DELETE
    @Path(value="/{id}")
    @Secured(right="kw-delete")
    public void delete(@PathParam(value="id") String functionId) throws FunctionTypeException {
        this.functionManager.deleteFunction(functionId);
    }

    @POST
    @Path(value="/search")
    @Secured(right="kw-read")
    public Function get(Map<String, String> attributes) {
        return this.functionManager.getFunctionByAttributes(attributes);
    }

    @GET
    @Path(value="/{id}")
    @Secured(right="kw-read")
    public Function get(@PathParam(value="id") String functionId) {
        return this.functionManager.getFunctionById(functionId);
    }

    @GET
    @Path(value="/{id}/editor")
    @Secured(right="kw-read")
    public String getFunctionEditor(@PathParam(value="id") String functionId) {
        Function function = this.functionManager.getFunctionById(functionId);
        FunctionEditor editor = ((FunctionEditorRegistry)this.getContext().get(FunctionEditorRegistry.class)).getFunctionEditor(function);
        if (editor != null) {
            return editor.getEditorPath(function);
        }
        return null;
    }

    @GET
    @Path(value="/types/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="kw-read")
    public Function newFunctionTypeConf(@PathParam(value="id") String type) {
        Function newFunction = this.functionManager.newFunction(type);
        newFunction.setAttributes(new HashMap());
        newFunction.getAttributes().put("name", "");
        newFunction.setSchema(Json.createObjectBuilder().build());
        return newFunction;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/executor/tokens/select")
    @Secured(right="kw-execute")
    public TokenWrapper getTokenHandle(GetTokenHandleParameter parameter) throws FunctionExecutionServiceException {
        return this.functionExecutionService.getTokenHandle(parameter.attributes, parameter.interests, parameter.createSession);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/executor/tokens/return")
    @Secured(right="kw-execute")
    public void returnTokenHandle(TokenWrapper token) throws FunctionExecutionServiceException {
        this.functionExecutionService.returnTokenHandle(token);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/executor/execute")
    @Secured(right="kw-execute")
    public Output callFunction(CallFunctionInput input) {
        if (input.functionId != null) {
            return this.functionExecutionService.callFunction(input.tokenHandle, input.functionId, input.input);
        }
        return this.functionExecutionService.callFunction(input.tokenHandle, input.functionAttributes, input.input);
    }

    public static class CallFunctionInput {
        String functionId;
        Map<String, String> functionAttributes;
        TokenWrapper tokenHandle;
        Input input;

        public String getFunctionId() {
            return this.functionId;
        }

        public void setFunctionId(String functionId) {
            this.functionId = functionId;
        }

        public TokenWrapper getTokenHandle() {
            return this.tokenHandle;
        }

        public void setTokenHandle(TokenWrapper tokenHandle) {
            this.tokenHandle = tokenHandle;
        }

        public Map<String, String> getFunctionAttributes() {
            return this.functionAttributes;
        }

        public void setFunctionAttributes(Map<String, String> functionAttributes) {
            this.functionAttributes = functionAttributes;
        }

        public Input getInput() {
            return this.input;
        }

        public void setInput(Input input) {
            this.input = input;
        }
    }

    public static class GetTokenHandleParameter {
        Map<String, String> attributes;
        Map<String, Interest> interests;
        boolean createSession;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public Map<String, Interest> getInterests() {
            return this.interests;
        }

        public void setInterests(Map<String, Interest> interests) {
            this.interests = interests;
        }

        public boolean isCreateSession() {
            return this.createSession;
        }

        public void setCreateSession(boolean createSession) {
            this.createSession = createSession;
        }
    }
}

