/*
 * Decompiled with CFR 0.152.
 */
package step.functions.runner;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import step.attachments.AttachmentManager;
import step.attachments.FileResolver;
import step.commons.conf.Configuration;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.expressions.ExpressionHandler;
import step.functions.Function;
import step.functions.Input;
import step.functions.Output;
import step.functions.accessor.FunctionAccessor;
import step.functions.accessor.FunctionCRUDAccessor;
import step.functions.accessor.InMemoryFunctionAccessorImpl;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceImpl;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistryImpl;
import step.grid.Grid;
import step.grid.GridFileService;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.client.GridClient;
import step.grid.client.GridClientImpl;
import step.grid.tokenpool.TokenRegistry;

public class FunctionRunner {
    public static Context getContext(AbstractFunctionType<?> functionType) {
        return new Context(new Configuration(), functionType, null);
    }

    public static Context getContext(AbstractFunctionType<?> functionType, Map<String, String> properties) {
        return new Context(new Configuration(), functionType, properties);
    }

    public static Context getContext(Configuration configuration, AbstractFunctionType<?> functionType, Map<String, String> properties) {
        return new Context(configuration, functionType, properties);
    }

    public static class Context {
        AgentTokenWrapper token;
        FunctionExecutionService functionExecutionService;
        FunctionCRUDAccessor functionAccessor = new InMemoryFunctionAccessorImpl();

        protected Context(Configuration configuration, AbstractFunctionType<?> functionType, Map<String, String> properties) {
            this.token = new AgentTokenWrapper();
            if (properties != null) {
                this.token.setProperties(properties);
            }
            Grid grid = new Grid(Integer.valueOf(0));
            GridClientImpl client = new GridClientImpl((TokenRegistry)grid, (GridFileService)grid);
            FunctionTypeRegistryImpl functionTypeRegistry = new FunctionTypeRegistryImpl(new FileResolver(new AttachmentManager(configuration)), (GridFileService)grid);
            functionTypeRegistry.registerFunctionType(functionType);
            this.functionExecutionService = new FunctionExecutionServiceImpl((GridClient)client, (FunctionAccessor)this.functionAccessor, functionTypeRegistry, new DynamicBeanResolver(new DynamicValueResolver(new ExpressionHandler())));
        }

        private JsonObject read(String argument) {
            return Json.createReader((Reader)new StringReader(argument)).readObject();
        }

        public Output run(Function function, String argument, Map<String, String> properties) {
            return this.run(function, this.read(argument), properties);
        }

        public Output run(Function function, JsonObject argument, Map<String, String> properties) {
            this.functionAccessor.save((AbstractIdentifiableObject)function);
            Input input = new Input();
            input.setArgument(argument);
            input.setProperties(properties);
            try {
                return this.functionExecutionService.callFunction(this.functionExecutionService.getLocalTokenHandle(), function.getId().toString(), input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

