/*
 * Decompiled with CFR 0.152.
 */
package step.functions.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.functions.Function;
import step.functions.Input;
import step.functions.Output;
import step.functions.accessor.FunctionAccessor;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistry;
import step.grid.TokenWrapper;
import step.grid.client.GridClient;
import step.grid.client.GridClientImpl;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.AgentError;
import step.grid.io.AgentErrorCode;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.grid.io.OutputMessage;
import step.grid.tokenpool.Interest;

public class FunctionExecutionServiceImpl
implements FunctionExecutionService {
    private final GridClient gridClient;
    private final FunctionAccessor functionAccessor;
    private final FunctionTypeRegistry functionTypeRegistry;
    private final DynamicBeanResolver dynamicBeanResolver;
    private static final Logger logger = LoggerFactory.getLogger(FunctionExecutionServiceImpl.class);

    public FunctionExecutionServiceImpl(GridClient gridClient, FunctionAccessor functionAccessor, FunctionTypeRegistry functionTypeRegistry, DynamicBeanResolver dynamicBeanResolver) {
        this.gridClient = gridClient;
        this.functionAccessor = functionAccessor;
        this.functionTypeRegistry = functionTypeRegistry;
        this.dynamicBeanResolver = dynamicBeanResolver;
    }

    @Override
    public TokenWrapper getLocalTokenHandle() {
        return this.gridClient.getLocalTokenHandle();
    }

    @Override
    public TokenWrapper getTokenHandle(Map<String, String> attributes, Map<String, Interest> interests, boolean createSession) throws FunctionExecutionServiceException {
        try {
            return this.gridClient.getTokenHandle(attributes, interests, createSession);
        }
        catch (GridClientImpl.AgentCallTimeoutException e) {
            throw new FunctionExecutionServiceException("Timeout after " + e.getCallTimeout() + "ms while reserving the agent token. You can increase the call timeout by setting 'grid.client.token.reserve.timeout.ms' in step.properties", e);
        }
        catch (GridClientImpl.AgentSideException e) {
            throw new FunctionExecutionServiceException("Unexepected error on the agent side while reserving the agent token: " + e.getMessage(), e);
        }
        catch (GridClientImpl.AgentCommunicationException e) {
            throw new FunctionExecutionServiceException("Communication error between the controller and the agent while reserving the agent token", e);
        }
    }

    @Override
    public void returnTokenHandle(TokenWrapper adapterToken) throws FunctionExecutionServiceException {
        try {
            this.gridClient.returnTokenHandle(adapterToken);
        }
        catch (GridClientImpl.AgentCallTimeoutException e) {
            throw new FunctionExecutionServiceException("Timeout after " + e.getCallTimeout() + "ms while releasing the agent token. You can increase the call timeout by setting 'grid.client.token.release.timeout.ms' in step.properties", e);
        }
        catch (GridClientImpl.AgentSideException e) {
            throw new FunctionExecutionServiceException("Unexepected error on the agent side while releasing the agent token: " + e.getMessage(), e);
        }
        catch (GridClientImpl.AgentCommunicationException e) {
            throw new FunctionExecutionServiceException("Communication error between the controller and the agent while releasing the agent token", e);
        }
    }

    @Override
    public Output callFunction(TokenWrapper tokenHandle, Map<String, String> functionAttributes, Input input) {
        Function function = (Function)this.functionAccessor.findByAttributes(functionAttributes);
        return this.callFunction(tokenHandle, function.getId().toString(), input);
    }

    @Override
    public Output callFunction(TokenWrapper tokenHandle, String functionId, Input input) {
        Function function = (Function)this.functionAccessor.get(new ObjectId(functionId));
        Output output = new Output();
        output.setFunction(function);
        try {
            OutputMessage outputMessage;
            AbstractFunctionType<Function> functionType = this.functionTypeRegistry.getFunctionTypeByFunction(function);
            this.dynamicBeanResolver.evaluate((Object)function, Collections.unmodifiableMap(input.getProperties()));
            String handlerChain = functionType.getHandlerChain(function);
            FileManagerClient.FileVersionId handlerPackage = functionType.getHandlerPackage(function);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(input.getProperties());
            Map<String, String> handlerProperties = functionType.getHandlerProperties(function);
            if (handlerProperties != null) {
                properties.putAll(handlerProperties);
            }
            functionType.beforeFunctionCall(function, input, properties);
            int callTimeout = (Integer)function.getCallTimeout().get();
            try {
                outputMessage = this.gridClient.call(tokenHandle, (String)function.getAttributes().get("name"), input.getArgument(), handlerChain, handlerPackage, properties, callTimeout);
            }
            catch (GridClientImpl.AgentCallTimeoutException e) {
                this.attachExceptionToOutput(output, "Timeout after " + callTimeout + "ms while calling the agent. You can increase the call timeout in the configuration screen of the keyword", (Exception)((Object)e));
                return output;
            }
            catch (GridClientImpl.AgentSideException e) {
                this.attachExceptionToOutput(output, "Unexepected error on the agent side: " + e.getMessage(), (Exception)((Object)e));
                return output;
            }
            catch (GridClientImpl.AgentCommunicationException e) {
                this.attachExceptionToOutput(output, "Communication error between the controller and the agent while calling the agent", (Exception)((Object)e));
                return output;
            }
            AgentError agentError = outputMessage.getAgentError();
            if (agentError != null) {
                AgentErrorCode errorCode = agentError.getErrorCode();
                if (errorCode.equals((Object)AgentErrorCode.TIMEOUT_REQUEST_INTERRUPTED)) {
                    output.setError("Timeout after " + callTimeout + "ms while executing the keyword on the agent. The keyword execution could be interrupted on the agent side. You can increase the call timeout in the configuration screen of the keyword");
                } else if (errorCode.equals((Object)AgentErrorCode.TIMEOUT_REQUEST_NOT_INTERRUPTED)) {
                    output.setError("Timeout after " + callTimeout + "ms while executing the keyword on the agent. WARNING: The keyword execution couldn't be interrupted on the agent side. You can increase the call timeout in the configuration screen of the keyword");
                } else if (errorCode.equals((Object)AgentErrorCode.TOKEN_NOT_FOUND)) {
                    output.setError("The agent token doesn't exist on the agent side");
                } else if (errorCode.equals((Object)AgentErrorCode.UNEXPECTED)) {
                    output.setError("Unexepected error while executing the keyword on the agent");
                } else if (errorCode.equals((Object)AgentErrorCode.CONTEXT_BUILDER)) {
                    output.setError("Unexpected error on the agent side while building the execution context of the keyword");
                } else if (errorCode.equals((Object)AgentErrorCode.CONTEXT_BUILDER_FILE_PROVIDER_CALL_ERROR)) {
                    output.setError("Error while downloading a resource from the controller");
                } else if (errorCode.equals((Object)AgentErrorCode.CONTEXT_BUILDER_FILE_PROVIDER_CALL_TIMEOUT)) {
                    String timeout = (String)agentError.getErrorDetails().get(AgentErrorCode.Details.TIMEOUT);
                    String filehandle = (String)agentError.getErrorDetails().get(AgentErrorCode.Details.FILE_HANDLE);
                    File file = this.gridClient.getRegisteredFile(filehandle);
                    if (file != null) {
                        output.setError("Timeout after " + timeout + "ms while downloading the following resource from the controller: " + file.getPath() + ". You can increase the download timeout by setting gridReadTimeout in AgentConf.js");
                    } else {
                        output.setError("Timeout after " + timeout + "ms while downloading a resource from the controller. You can increase the download timeout by setting gridReadTimeout in AgentConf.js");
                    }
                } else {
                    output.setError("Unknown agent error: " + agentError);
                }
            } else {
                output.setError(outputMessage.getError());
            }
            output.setResult(outputMessage.getPayload());
            output.setAttachments(outputMessage.getAttachments());
            output.setMeasures(outputMessage.getMeasures());
            return output;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("Unexpected error while calling function with id " + functionId, (Throwable)e);
            }
            this.attachExceptionToOutput(output, e);
            return output;
        }
    }

    private void attachExceptionToOutput(Output output, Exception e) {
        this.attachExceptionToOutput(output, "Unexpected error while calling keyword: " + e.getClass().getName() + " " + e.getMessage(), e);
    }

    private void attachExceptionToOutput(Output output, String message, Exception e) {
        output.setError(message);
        Attachment attachment = AttachmentHelper.generateAttachmentForException((Throwable)e);
        ArrayList<Attachment> attachments = output.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            output.setAttachments(attachments);
        }
        attachments.add(attachment);
    }
}

