/*
 * Decompiled with CFR 0.152.
 */
package step.functions.editors;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import step.functions.Function;
import step.functions.editors.FunctionEditor;

public class FunctionEditorRegistry {
    List<FunctionEditor> editors = new CopyOnWriteArrayList<FunctionEditor>();

    public <T extends Function> void register(FunctionEditor functionEditor) {
        this.editors.add(functionEditor);
    }

    public FunctionEditor getFunctionEditor(Function function) {
        for (FunctionEditor editor : this.editors) {
            if (!editor.isValidForFunction(function)) continue;
            return editor;
        }
        return null;
    }
}

