/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.Map;
import step.artefacts.FunctionGroup;
import step.artefacts.handlers.SequentialArtefactScheduler;
import step.artefacts.handlers.TokenSelectorHelper;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.core.dynamicbeans.DynamicJsonValueResolver;
import step.core.execution.ExecutionContext;
import step.functions.execution.FunctionExecutionService;
import step.grid.TokenWrapper;
import step.grid.tokenpool.Interest;

public class FunctionGroupHandler
extends ArtefactHandler<FunctionGroup, ReportNode> {
    public static final String FUNCTION_GROUP_CONTEXT_KEY = "##functionGroupContext##";
    private FunctionExecutionService functionExecutionService;
    private TokenSelectorHelper tokenSelectorHelper;

    public void init(ExecutionContext context) {
        super.init(context);
        this.functionExecutionService = (FunctionExecutionService)context.get(FunctionExecutionService.class);
        this.tokenSelectorHelper = new TokenSelectorHelper(new DynamicJsonObjectResolver(new DynamicJsonValueResolver(context.getExpressionHandler())));
    }

    protected void createReportSkeleton_(ReportNode node, FunctionGroup testArtefact) {
        SequentialArtefactScheduler scheduler = new SequentialArtefactScheduler(this.context);
        scheduler.createReportSkeleton_(node, (AbstractArtefact)testArtefact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_(ReportNode node, FunctionGroup testArtefact) throws Exception {
        Map<String, Interest> additionalSelectionCriteria = this.tokenSelectorHelper.getTokenSelectionCriteria(testArtefact, this.getBindings());
        FunctionGroupContext handle = new FunctionGroupContext(additionalSelectionCriteria);
        this.context.getVariablesManager().putVariable(node, FUNCTION_GROUP_CONTEXT_KEY, (Object)handle);
        try {
            SequentialArtefactScheduler scheduler = new SequentialArtefactScheduler(this.context);
            scheduler.execute_(node, (AbstractArtefact)testArtefact);
        }
        finally {
            if (handle.getToken() != null) {
                this.functionExecutionService.returnTokenHandle(handle.getToken());
            }
        }
    }

    public ReportNode createReportNode_(ReportNode parentNode, FunctionGroup testArtefact) {
        return new ReportNode();
    }

    public static class FunctionGroupContext {
        TokenWrapper token;
        final Map<String, Interest> additionalSelectionCriteria;

        public FunctionGroupContext(Map<String, Interest> additionalSelectionCriteria) {
            this.additionalSelectionCriteria = additionalSelectionCriteria;
        }

        public TokenWrapper getToken() {
            return this.token;
        }

        public void setToken(TokenWrapper token) {
            this.token = token;
        }

        public Map<String, Interest> getAdditionalSelectionCriteria() {
            return this.additionalSelectionCriteria;
        }
    }
}

