/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import javax.json.JsonObject;
import step.artefacts.Assert;
import step.artefacts.reports.AssertReportNode;
import step.artefacts.reports.CallFunctionReportNode;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;

public class AssertHandler
extends ArtefactHandler<Assert, AssertReportNode> {
    protected void createReportSkeleton_(AssertReportNode parentNode, Assert artefact) {
    }

    protected void execute_(AssertReportNode node, Assert artefact) {
        CallFunctionReportNode callFunctionReport = (CallFunctionReportNode)((Object)this.context.getVariablesManager().getVariable("callReport"));
        if (callFunctionReport == null) {
            throw new RuntimeException("Keyword report unreachable. Asserts should be wrapped in Keyword nodes in the test plan.");
        }
        if (callFunctionReport.getStatus() == ReportNodeStatus.PASSED) {
            boolean actualResolved;
            String actual;
            String message;
            boolean passed;
            String key;
            block21: {
                JsonObject outputJson = callFunctionReport.getOutputObject();
                key = (String)artefact.getActual().get();
                node.setKey(key);
                passed = false;
                message = null;
                actual = null;
                actualResolved = false;
                if (key.startsWith("$")) {
                    try {
                        Object result = JsonPath.parse((String)outputJson.toString()).read(key, new Predicate[0]);
                        if (result instanceof String) {
                            actual = (String)result;
                            actualResolved = true;
                            break block21;
                        }
                        passed = false;
                        message = "The json path '" + key + "' return an object of type " + result.getClass() + " which is not supported.";
                    }
                    catch (PathNotFoundException e) {
                        passed = false;
                        message = e.getMessage();
                    }
                } else if (outputJson.containsKey((Object)key)) {
                    actual = outputJson.getString(key);
                    actualResolved = true;
                } else {
                    passed = false;
                    message = "Unable to execute assertion. The keyword output doesn't contain the attribute '" + key + "'";
                }
            }
            if (actualResolved) {
                node.setActual(actual);
                Object expectedValueObject = artefact.getExpected().get();
                String expectedValue = expectedValueObject != null ? expectedValueObject.toString() : null;
                node.setExpected(expectedValue);
                boolean negate = artefact.isNegate();
                String not = negate ? " not " : " ";
                String description = "";
                Assert.AssertOperator operator = artefact.getOperator();
                if (operator == Assert.AssertOperator.EQUALS) {
                    passed = artefact.isNegate() ^ expectedValue.equals(actual);
                    message = "'" + key + "' expected" + not + "to be equal to '" + expectedValue + "' " + (passed ? "and" : "but") + " was '" + actual + "'";
                    description = key + (negate ? " !" : " ") + "= '" + expectedValue + "'";
                } else if (operator == Assert.AssertOperator.CONTAINS) {
                    passed = negate ^ actual.contains(expectedValue);
                    message = "'" + key + "' expected" + not + "to contain '" + expectedValue + "' " + (passed ? "and" : "but") + " was '" + actual + "'";
                    description = key + not + "contains '" + expectedValue + "'";
                } else if (operator == Assert.AssertOperator.BEGINS_WITH) {
                    passed = negate ^ actual.startsWith(expectedValue);
                    message = "'" + key + "' expected" + not + "to begin with '" + expectedValue + "' " + (passed ? "and" : "but") + " was '" + actual + "'";
                    description = key + not + "begins with '" + expectedValue + "'";
                } else if (operator == Assert.AssertOperator.ENDS_WITH) {
                    passed = negate ^ actual.endsWith(expectedValue);
                    message = "'" + key + "' expected" + not + "to end with '" + expectedValue + "' " + (passed ? "and" : "but") + " was '" + actual + "'";
                    description = key + not + "ends with '" + expectedValue + "'";
                } else if (operator == Assert.AssertOperator.MATCHES) {
                    passed = negate ^ actual.matches(expectedValue);
                    message = "'" + key + "' expected" + not + "to match regular expression '" + expectedValue + "' " + (passed ? "and" : "but") + " was '" + actual + "'";
                    description = key + not + "matches '" + expectedValue + "'";
                } else {
                    throw new RuntimeException("Unsupported operator " + (Object)((Object)operator));
                }
                node.setDescription(description);
            }
            node.setMessage(message);
            node.setStatus(passed ? ReportNodeStatus.PASSED : ReportNodeStatus.FAILED);
        } else {
            node.setStatus(ReportNodeStatus.NORUN);
        }
    }

    public AssertReportNode createReportNode_(ReportNode parentNode, Assert artefact) {
        return new AssertReportNode();
    }
}

