/*
 * Decompiled with CFR 0.152.
 */
package step.functions.runner;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import step.core.GlobalContext;
import step.core.execution.ContextBuilder;
import step.functions.Function;
import step.functions.FunctionClient;
import step.functions.FunctionRepository;
import step.functions.Input;
import step.functions.Output;
import step.functions.type.AbstractFunctionType;
import step.grid.Grid;
import step.grid.GridFileService;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.client.GridClient;
import step.grid.tokenpool.TokenRegistry;

public class FunctionRunner {
    public static Context getContext(AbstractFunctionType<?> functionType) {
        return new Context(functionType, null);
    }

    public static Context getContext(AbstractFunctionType<?> functionType, Map<String, String> properties) {
        return new Context(functionType, properties);
    }

    public static class Context {
        GlobalContext globalContext;
        AgentTokenWrapper token;
        FunctionClient functionClient;
        FunctionRepository functionRepository = new FunctionRepository(){
            Map<String, Function> functions = new HashMap<String, Function>();

            @Override
            public Function getFunctionById(String id) {
                return this.functions.get(id);
            }

            @Override
            public Function getFunctionByAttributes(Map<String, String> attributes) {
                throw new RuntimeException();
            }

            @Override
            public void deleteFunction(String functionId) {
            }

            @Override
            public void addFunction(Function function) {
                this.functions.put(function.getId().toString(), function);
            }
        };

        public Context(AbstractFunctionType<?> functionType, Map<String, String> properties) {
            this.token = new AgentTokenWrapper();
            if (properties != null) {
                this.token.setProperties(properties);
            }
            this.globalContext = ContextBuilder.createGlobalContext();
            Grid grid = new Grid(Integer.valueOf(0));
            GridClient client = new GridClient((TokenRegistry)grid, (GridFileService)grid);
            this.functionClient = new FunctionClient(this.globalContext, client, this.functionRepository);
            this.functionClient.registerFunctionType(functionType);
            this.globalContext.put("FunctionClient_Instance", (Object)this.functionClient);
        }

        private JsonObject read(String argument) {
            return Json.createReader((Reader)new StringReader(argument)).readObject();
        }

        public Output run(Function function, String argument, Map<String, String> properties) {
            return this.run(function, this.read(argument), properties);
        }

        public Output run(Function function, JsonObject argument, Map<String, String> properties) {
            this.functionRepository.addFunction(function);
            Input input = new Input();
            input.setArgument(argument);
            input.setProperties(properties);
            try {
                return this.functionClient.callFunction(this.functionClient.getLocalTokenHandle(), function.getId().toString(), input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public GlobalContext getGlobalContext() {
            return this.globalContext;
        }
    }
}

