/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import com.mongodb.MongoClient;
import org.jongo.MongoCollection;
import step.commons.conf.Configuration;
import step.core.GlobalContext;
import step.core.accessors.MongoDBAccessorHelper;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.core.dynamicbeans.DynamicJsonValueResolver;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.functions.FunctionClient;
import step.functions.FunctionExecutionService;
import step.functions.FunctionRepository;
import step.functions.editors.FunctionEditorRegistry;
import step.functions.routing.FunctionRouter;
import step.grid.Grid;
import step.grid.GridFileService;
import step.grid.client.GridClient;
import step.grid.tokenpool.TokenRegistry;
import step.plugins.adaptergrid.FunctionRepositoryImpl;
import step.plugins.adaptergrid.FunctionRepositoryServices;
import step.plugins.adaptergrid.GridServices;

@Plugin
public class GridPlugin
extends AbstractPlugin {
    public static final String GRID_KEY = "Grid_Instance";
    public static final String GRIDCLIENT_KEY = "GridClient_Instance";
    public static final String FUNCTIONCLIENT_KEY = "FunctionClient_Instance";

    public void executionControllerStart(GlobalContext context) throws Exception {
        Integer gridPort = Configuration.getInstance().getPropertyAsInteger("grid.port", Integer.valueOf(8081));
        Integer tokenTTL = Configuration.getInstance().getPropertyAsInteger("grid.ttl", Integer.valueOf(60000));
        Grid grid = new Grid(gridPort, tokenTTL);
        grid.start();
        GridClient client = new GridClient((TokenRegistry)grid, (GridFileService)grid);
        MongoClient mongoClient = context.getMongoClient();
        MongoCollection functionCollection = MongoDBAccessorHelper.getCollection((MongoClient)mongoClient, (String)"functions");
        FunctionEditorRegistry editorRegistry = new FunctionEditorRegistry();
        context.put(FunctionEditorRegistry.class.getName(), (Object)editorRegistry);
        FunctionRepositoryImpl functionRepository = new FunctionRepositoryImpl(functionCollection);
        FunctionClient functionClient = new FunctionClient(context, client, functionRepository);
        context.put(GRID_KEY, (Object)grid);
        context.put(GRIDCLIENT_KEY, (Object)client);
        context.put(FUNCTIONCLIENT_KEY, (Object)functionClient);
        context.put(FunctionExecutionService.class.getName(), (Object)functionClient);
        context.put(FunctionRepository.class.getName(), (Object)functionRepository);
        DynamicJsonObjectResolver dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(context.getExpressionHandler()));
        context.put(FunctionRouter.class.getName(), (Object)new FunctionRouter(functionClient, functionClient, dynamicJsonObjectResolver));
        context.getServiceRegistrationCallback().registerService(GridServices.class);
        context.getServiceRegistrationCallback().registerService(FunctionRepositoryServices.class);
    }

    public void executionControllerDestroy(GlobalContext context) {
        Object o = context.get((Object)GRIDCLIENT_KEY);
        if (o != null) {
            ((GridClient)o).close();
        }
    }
}

