/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import java.util.Iterator;
import java.util.Map;
import javax.json.JsonObjectBuilder;
import javax.json.spi.JsonProvider;
import org.bson.types.ObjectId;
import org.jongo.MongoCollection;
import step.functions.Function;
import step.functions.FunctionRepository;

public class FunctionRepositoryImpl
implements FunctionRepository {
    private MongoCollection functions;
    private static JsonProvider jsonProvider = JsonProvider.provider();

    public FunctionRepositoryImpl(MongoCollection functions) {
        this.functions = functions;
    }

    @Override
    public Function getFunctionById(String id) {
        return (Function)this.functions.findOne(new ObjectId(id)).as(Function.class);
    }

    @Override
    public Function getFunctionByAttributes(Map<String, String> attributes) {
        JsonObjectBuilder builder = jsonProvider.createObjectBuilder();
        for (String key : attributes.keySet()) {
            builder.add("attributes." + key, attributes.get(key));
        }
        String query = builder.build().toString();
        Iterator it = this.functions.find(query).as(Function.class).iterator();
        if (it.hasNext()) {
            Function function = (Function)it.next();
            if (it.hasNext()) {
                // empty if block
            }
            return function;
        }
        throw new RuntimeException("Unable to find keyword " + attributes.toString());
    }

    @Override
    public void addFunction(Function function) {
        this.functions.save((Object)function);
    }

    @Override
    public void deleteFunction(String functionId) {
        this.functions.remove(new ObjectId(functionId));
    }
}

