/*
 * Decompiled with CFR 0.152.
 */
package step.functions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.functions.Function;
import step.functions.FunctionExecutionService;
import step.functions.FunctionRepository;
import step.functions.FunctionTypeRegistry;
import step.functions.Input;
import step.functions.Output;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.grid.TokenWrapper;
import step.grid.client.GridClient;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.grid.io.OutputMessage;
import step.grid.tokenpool.Interest;

public class FunctionClient
implements FunctionExecutionService,
FunctionTypeRegistry {
    private final GridClient gridClient;
    private final FunctionRepository functionRepository;
    private final GlobalContext context;
    private final Map<String, AbstractFunctionType<Function>> functionTypes = new HashMap<String, AbstractFunctionType<Function>>();
    private static final Logger logger = LoggerFactory.getLogger(FunctionClient.class);

    public FunctionClient(GlobalContext context, GridClient gridClient, FunctionRepository functionRepository) {
        this.context = context;
        this.gridClient = gridClient;
        this.functionRepository = functionRepository;
    }

    @Override
    public TokenWrapper getLocalTokenHandle() {
        return this.gridClient.getLocalTokenHandle();
    }

    @Override
    public TokenWrapper getTokenHandle(Map<String, String> attributes, Map<String, Interest> interests, boolean createSession) throws GridClient.AgentCommunicationException {
        return this.gridClient.getTokenHandle(attributes, interests, createSession);
    }

    @Override
    public void returnTokenHandle(TokenWrapper adapterToken) throws GridClient.AgentCommunicationException {
        adapterToken.setCurrentOwner(null);
        this.gridClient.returnTokenHandle(adapterToken);
    }

    @Override
    public Output callFunction(TokenWrapper tokenHandle, Map<String, String> functionAttributes, Input input) {
        Function function = this.functionRepository.getFunctionByAttributes(functionAttributes);
        return this.callFunction(tokenHandle, function.getId().toString(), input);
    }

    @Override
    public Output callFunction(TokenWrapper tokenHandle, String functionId, Input input) {
        Function function = this.functionRepository.getFunctionById(functionId);
        Output output = new Output();
        output.setFunction(function);
        try {
            AbstractFunctionType<Function> functionType = this.getFunctionTypeByFunction(function);
            this.context.getDynamicBeanResolver().evaluate((Object)function, Collections.unmodifiableMap(input.getProperties()));
            String handlerChain = functionType.getHandlerChain(function);
            FileManagerClient.FileVersionId handlerPackage = functionType.getHandlerPackage(function);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(input.getProperties());
            Map<String, String> handlerProperties = functionType.getHandlerProperties(function);
            if (handlerProperties != null) {
                properties.putAll(handlerProperties);
            }
            functionType.beforeFunctionCall(function, input, properties);
            int callTimeout = (Integer)function.getCallTimeout().get();
            OutputMessage outputMessage = this.gridClient.call(tokenHandle, function.getAttributes().get("name"), input.getArgument(), handlerChain, handlerPackage, properties, callTimeout);
            output.setResult(outputMessage.getPayload());
            output.setError(outputMessage.getError());
            output.setAttachments(outputMessage.getAttachments());
            output.setMeasures(outputMessage.getMeasures());
            return output;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("Error while calling function with id " + functionId, (Throwable)e);
            }
            FunctionClient.attachExceptionToOutput(output, e);
            return output;
        }
    }

    public static void attachExceptionToOutput(Output output, Exception e) {
        output.setError("Unexpected error while calling function: " + e.getClass().getName() + " " + e.getMessage());
        Attachment attachment = AttachmentHelper.generateAttachmentForException((Throwable)e);
        List<Attachment> attachments = output.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            output.setAttachments(attachments);
        }
        attachments.add(attachment);
    }

    @Override
    public void registerFunctionType(AbstractFunctionType<? extends Function> functionType) {
        functionType.setContext(this.context);
        functionType.init();
        this.functionTypes.put(functionType.newFunction().getClass().getName(), functionType);
    }

    private AbstractFunctionType<Function> getFunctionTypeByType(String functionType) {
        AbstractFunctionType<Function> type = this.functionTypes.get(functionType);
        if (type == null) {
            throw new RuntimeException("Unknown function type '" + functionType + "'");
        }
        return type;
    }

    @Override
    public AbstractFunctionType<Function> getFunctionTypeByFunction(Function function) {
        return this.getFunctionTypeByType(function.getClass().getName());
    }

    public void setupFunction(Function function) throws SetupFunctionException {
        AbstractFunctionType<Function> type = this.getFunctionTypeByFunction(function);
        type.setupFunction(function);
    }

    public Function copyFunction(Function function) throws FunctionTypeException {
        AbstractFunctionType<Function> type = this.getFunctionTypeByFunction(function);
        return type.copyFunction(function);
    }

    public Function updateFunction(Function function) throws FunctionTypeException {
        AbstractFunctionType<Function> type = this.getFunctionTypeByFunction(function);
        return type.updateFunction(function);
    }

    public void deleteFunction(Function function) throws FunctionTypeException {
        AbstractFunctionType<Function> type = this.getFunctionTypeByFunction(function);
        type.deleteFunction(function);
    }

    public String registerAgentFile(File file) {
        return this.gridClient.registerFile(file);
    }

    public FunctionRepository getFunctionRepository() {
        return this.functionRepository;
    }

    public Function newFunction(String type) {
        return this.getFunctionTypeByType(type).newFunction();
    }
}

