/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import step.core.artefacts.reports.ReportNode;
import step.core.deployment.AbstractServices;
import step.grid.AgentRef;
import step.grid.Grid;
import step.grid.GridReportBuilder;
import step.grid.reports.TokenAssociation;
import step.grid.reports.TokenGroupCapacity;

@Path(value="/grid")
public class GridServices
extends AbstractServices {
    private Grid getAdapterGrid() {
        return (Grid)this.getContext().get((Object)"Grid_Instance");
    }

    private GridReportBuilder getReportBuilder() {
        return new GridReportBuilder(this.getAdapterGrid());
    }

    @GET
    @Path(value="/agent")
    @Produces(value={"application/json"})
    public Collection<AgentRef> getAgents() {
        return this.getAdapterGrid().getAgents();
    }

    @PUT
    @Path(value="/agent/{id}/interrupt")
    @Produces(value={"application/json"})
    public void interruptAgent(@PathParam(value="id") String agentId) {
    }

    @PUT
    @Path(value="/agent/{id}/resume")
    @Produces(value={"application/json"})
    public void resumeAgent(@PathParam(value="id") String agentId) {
    }

    @GET
    @Path(value="/token")
    @Produces(value={"application/json"})
    public List<TokenAssociation> getTokenAssociations() {
        return this.getReportBuilder().getTokenAssociations(false);
    }

    @GET
    @Path(value="/token/search")
    @Produces(value={"application/json"})
    public List<TokenAssociation> getTokenAssociations(@QueryParam(value="eid") String executionID) {
        ArrayList<TokenAssociation> result = new ArrayList<TokenAssociation>();
        for (TokenAssociation assoc : this.getReportBuilder().getTokenAssociations(true)) {
            Object owner = assoc.getOwner();
            if (owner == null || !(owner instanceof ReportNode) || !((ReportNode)owner).getExecutionID().equals(executionID)) continue;
            result.add(assoc);
        }
        return result;
    }

    @GET
    @Path(value="/token/usage")
    @Produces(value={"application/json"})
    public List<TokenGroupCapacity> getUsageByIdentity(@QueryParam(value="groupby") List<String> groupbys) {
        return this.getReportBuilder().getUsageByIdentity(groupbys);
    }

    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    public Set<String> getTokenAttributeKeys() {
        return this.getReportBuilder().getTokenAttributeKeys();
    }
}

