/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.adaptergrid;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.json.Json;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import step.core.GlobalContext;
import step.core.artefacts.reports.ReportNode;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.ExecutionContext;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.miscellaneous.ReportNodeAttachmentManager;
import step.functions.Function;
import step.functions.FunctionClient;
import step.functions.FunctionRepository;
import step.functions.Input;
import step.functions.Output;
import step.functions.editors.FunctionEditor;
import step.functions.editors.FunctionEditorRegistry;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.grid.TokenWrapper;
import step.grid.client.GridClient;
import step.grid.tokenpool.Interest;

@Path(value="/functions")
public class FunctionRepositoryServices
extends AbstractServices {
    ReportNodeAttachmentManager reportNodeAttachmentManager;

    private FunctionClient getFunctionClient() {
        return (FunctionClient)this.getContext().get((Object)"FunctionClient_Instance");
    }

    private FunctionRepository getFunctionRepository() {
        return this.getFunctionClient().getFunctionRepository();
    }

    @PostConstruct
    public void init() {
        this.reportNodeAttachmentManager = new ReportNodeAttachmentManager(this.getContext().getAttachmentManager());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    @Secured(right="kw-write")
    public Function save(Function function) throws SetupFunctionException, FunctionTypeException {
        FunctionRepository repo = this.getFunctionRepository();
        if (function.getId() == null || repo.getFunctionById(function.getId().toString()) == null) {
            this.getFunctionClient().setupFunction(function);
        } else {
            this.getFunctionClient().updateFunction(function);
        }
        repo.addFunction(function);
        return function;
    }

    @POST
    @Path(value="/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="kw-write")
    public void copyFunction(@PathParam(value="id") String id) throws FunctionTypeException {
        FunctionRepository repo = this.getFunctionRepository();
        Function source = repo.getFunctionById(id);
        if (source != null) {
            Function copy = this.getFunctionClient().copyFunction(source);
            repo.addFunction(copy);
        }
    }

    public static ExecutionContext createContext(GlobalContext g) {
        ReportNode root = new ReportNode();
        ExecutionContext c = new ExecutionContext("");
        c.setGlobalContext(g);
        c.getReportNodeCache().put(root);
        c.setReport(root);
        ExecutionContext.setCurrentReportNode((ReportNode)root);
        c.setExecutionParameters(new ExecutionParameters("dummy", null, ExecutionMode.RUN));
        return c;
    }

    @DELETE
    @Path(value="/{id}")
    @Secured(right="kw-delete")
    public void delete(@PathParam(value="id") String functionId) throws FunctionTypeException {
        FunctionRepository repo = this.getFunctionRepository();
        Function function = repo.getFunctionById(functionId);
        this.getFunctionClient().deleteFunction(function);
        this.getFunctionRepository().deleteFunction(functionId);
    }

    @POST
    @Path(value="/search")
    @Secured(right="kw-read")
    public Function get(Map<String, String> attributes) {
        return this.getFunctionRepository().getFunctionByAttributes(attributes);
    }

    @GET
    @Path(value="/{id}")
    @Secured(right="kw-read")
    public Function get(@PathParam(value="id") String functionId) {
        return this.getFunctionRepository().getFunctionById(functionId);
    }

    @GET
    @Path(value="/{id}/editor")
    @Secured(right="kw-read")
    public String getFunctionEditor(@PathParam(value="id") String functionId) {
        Function function = this.getFunctionRepository().getFunctionById(functionId);
        FunctionEditor editor = ((FunctionEditorRegistry)this.getContext().get(FunctionEditorRegistry.class)).getFunctionEditor(function);
        if (editor != null) {
            return editor.getEditorPath(function);
        }
        return null;
    }

    @GET
    @Path(value="/types/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="kw-read")
    public Function newFunctionTypeConf(@PathParam(value="id") String type) {
        Function newFunction = this.getFunctionClient().newFunction(type);
        newFunction.setAttributes(new HashMap<String, String>());
        newFunction.getAttributes().put("name", "");
        newFunction.setSchema(Json.createObjectBuilder().build());
        return newFunction;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/executor/tokens/select")
    @Secured(right="kw-execute")
    public TokenWrapper getTokenHandle(GetTokenHandleParameter parameter) throws GridClient.AgentCommunicationException {
        return this.getFunctionClient().getTokenHandle(parameter.attributes, parameter.interests, parameter.createSession);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/executor/tokens/return")
    @Secured(right="kw-execute")
    public void returnTokenHandle(TokenWrapper token) throws GridClient.AgentCommunicationException {
        this.getFunctionClient().returnTokenHandle(token);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/executor/execute")
    @Secured(right="kw-execute")
    public Output callFunction(CallFunctionInput input) {
        if (input.functionId != null) {
            return this.getFunctionClient().callFunction(input.tokenHandle, input.functionId, input.input);
        }
        return this.getFunctionClient().callFunction(input.tokenHandle, input.functionAttributes, input.input);
    }

    public static class CallFunctionInput {
        String functionId;
        Map<String, String> functionAttributes;
        TokenWrapper tokenHandle;
        Input input;

        public String getFunctionId() {
            return this.functionId;
        }

        public void setFunctionId(String functionId) {
            this.functionId = functionId;
        }

        public TokenWrapper getTokenHandle() {
            return this.tokenHandle;
        }

        public void setTokenHandle(TokenWrapper tokenHandle) {
            this.tokenHandle = tokenHandle;
        }

        public Map<String, String> getFunctionAttributes() {
            return this.functionAttributes;
        }

        public void setFunctionAttributes(Map<String, String> functionAttributes) {
            this.functionAttributes = functionAttributes;
        }

        public Input getInput() {
            return this.input;
        }

        public void setInput(Input input) {
            this.input = input;
        }
    }

    public static class GetTokenHandleParameter {
        Map<String, String> attributes;
        Map<String, Interest> interests;
        boolean createSession;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public Map<String, Interest> getInterests() {
            return this.interests;
        }

        public void setInterests(Map<String, Interest> interests) {
            this.interests = interests;
        }

        public boolean isCreateSession() {
            return this.createSession;
        }

        public void setCreateSession(boolean createSession) {
            this.createSession = createSession;
        }
    }
}

