/*
 * Decompiled with CFR 0.152.
 */
package step.functions.type;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import step.attachments.FileResolver;
import step.commons.helpers.FileHelper;
import step.core.GlobalContext;
import step.core.dynamicbeans.DynamicValue;
import step.functions.Function;
import step.functions.FunctionClient;
import step.functions.Input;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.grid.filemanager.FileManagerClient;
import step.grid.tokenpool.Interest;

public abstract class AbstractFunctionType<T extends Function> {
    protected GlobalContext context;

    public GlobalContext getContext() {
        return this.context;
    }

    public void setContext(GlobalContext context) {
        this.context = context;
    }

    public void init() {
    }

    public Map<String, Interest> getTokenSelectionCriteria(T function) {
        HashMap<String, Interest> criteria = new HashMap<String, Interest>();
        criteria.put("$agenttype", new Interest(Pattern.compile("default"), true));
        return criteria;
    }

    public abstract String getHandlerChain(T var1);

    public FileManagerClient.FileVersionId getHandlerPackage(T function) {
        return null;
    }

    public abstract Map<String, String> getHandlerProperties(T var1);

    public void beforeFunctionCall(T function, Input input, Map<String, String> properties) {
    }

    public abstract T newFunction();

    public void setupFunction(T function) throws SetupFunctionException {
    }

    public T updateFunction(T function) throws FunctionTypeException {
        return function;
    }

    public T copyFunction(T function) throws FunctionTypeException {
        ((Function)function).setId(null);
        ((Function)function).getAttributes().put("name", ((Function)function).getAttributes().get("name") + "_Copy");
        return function;
    }

    protected void registerFile(DynamicValue<String> dynamicValue, String properyName, Map<String, String> props) {
        String filepath = (String)dynamicValue.get();
        if (filepath != null && filepath.trim().length() > 0) {
            FileResolver fileResolver = new FileResolver(this.context.getAttachmentManager());
            File file = fileResolver.resolve(filepath);
            this.registerFile(file, properyName, props);
        }
    }

    protected void registerFile(File file, String properyName, Map<String, String> props) {
        FunctionClient functionClient = (FunctionClient)this.context.get((Object)"FunctionClient_Instance");
        String fileHandle = functionClient.registerAgentFile(file);
        props.put(properyName + ".id", fileHandle);
        props.put(properyName + ".version", Long.toString(FileHelper.getLastModificationDateRecursive((File)file)));
    }

    protected FileManagerClient.FileVersionId registerFile(File file) {
        FunctionClient functionClient = (FunctionClient)this.context.get((Object)"FunctionClient_Instance");
        String fileHandle = functionClient.registerAgentFile(file);
        return new FileManagerClient.FileVersionId(fileHandle, FileHelper.getLastModificationDateRecursive((File)file));
    }

    protected FileManagerClient.FileVersionId registerFile(String filepath) {
        return this.registerFile(new File(filepath));
    }

    public void deleteFunction(T function) throws FunctionTypeException {
    }
}

