/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonParsingException;
import step.artefacts.CallFunction;
import step.artefacts.handlers.FunctionGroupHandler;
import step.artefacts.handlers.SelectorHelper;
import step.artefacts.handlers.SequentialArtefactScheduler;
import step.artefacts.reports.CallFunctionReportNode;
import step.attachments.AttachmentMeta;
import step.common.managedoperations.OperationManager;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.core.dynamicbeans.DynamicJsonValueResolver;
import step.core.execution.ExecutionContext;
import step.core.miscellaneous.ReportNodeAttachmentManager;
import step.core.variables.VariablesManager;
import step.datapool.DataSetHandle;
import step.functions.Function;
import step.functions.FunctionExecutionService;
import step.functions.FunctionRepository;
import step.functions.Input;
import step.functions.Output;
import step.functions.routing.FunctionRouter;
import step.functions.validation.JsonSchemaValidator;
import step.grid.Token;
import step.grid.TokenWrapper;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;

public class CallFunctionHandler
extends ArtefactHandler<CallFunction, CallFunctionReportNode> {
    public static final String STEP_NODE_KEY = "currentStep";
    protected FunctionExecutionService functionExecutionService;
    protected FunctionRepository functionRepository;
    protected ReportNodeAttachmentManager reportNodeAttachmentManager;
    protected DynamicJsonObjectResolver dynamicJsonObjectResolver;
    private static JsonProvider jprov = JsonProvider.provider();
    private SelectorHelper selectorHelper;
    private FunctionRouter functionRouter;
    public static final String EXECUTION_CONTEXT_KEY = "$executionContext";
    public static final String ARTEFACTID = "$artefactid";
    public static final String PARENTREPORTID = "$parentreportid";

    public void init(ExecutionContext context) {
        super.init(context);
        this.functionExecutionService = (FunctionExecutionService)context.getGlobalContext().get(FunctionExecutionService.class);
        this.functionRepository = (FunctionRepository)context.getGlobalContext().get(FunctionRepository.class);
        this.functionRouter = (FunctionRouter)context.getGlobalContext().get(FunctionRouter.class);
        this.reportNodeAttachmentManager = new ReportNodeAttachmentManager(context);
        this.dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(context.getGlobalContext().getExpressionHandler()));
        this.selectorHelper = new SelectorHelper(this.dynamicJsonObjectResolver);
    }

    protected void createReportSkeleton_(CallFunctionReportNode parentNode, CallFunction testArtefact) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_(CallFunctionReportNode node, CallFunction testArtefact) throws Exception {
        String argumentStr = (String)testArtefact.getArgument().get();
        node.setInput(argumentStr);
        Function function = this.getFunction(testArtefact);
        node.setFunctionId(function.getId().toString());
        node.setFunctionAttributes(function.getAttributes());
        Input input = this.buildInput(argumentStr);
        node.setInput(input.getArgument().toString());
        this.validateInput(input, function);
        if (!this.context.isSimulation()) {
            Object o = this.context.getVariablesManager().getVariable("##functionGroupContext##");
            boolean releaseTokenAfterExecution = o == null;
            TokenWrapper token = this.functionRouter.selectToken(testArtefact, function, (FunctionGroupHandler.FunctionGroupContext)o, this.getBindings());
            try {
                Output output;
                Token gridToken = token.getToken();
                if (gridToken.isLocal()) {
                    gridToken.attachObject(EXECUTION_CONTEXT_KEY, (Object)this.context);
                }
                node.setAgentUrl(token.getAgent().getAgentUrl());
                node.setTokenId(token.getID());
                token.setCurrentOwner((Object)node);
                OperationManager.getInstance().enter("Keyword Call", (Object)new Object[]{function.getAttributes(), token.getToken(), token.getAgent()});
                try {
                    output = this.functionExecutionService.callFunction(token, function.getId().toString(), input);
                }
                finally {
                    OperationManager.getInstance().exit();
                }
                String errorMsg = output.getError();
                if (errorMsg != null) {
                    node.setError(errorMsg, 0, true);
                    node.setStatus(ReportNodeStatus.TECHNICAL_ERROR);
                } else {
                    node.setStatus(ReportNodeStatus.PASSED);
                }
                if (output.getResult() != null) {
                    this.context.getVariablesManager().putVariable((ReportNode)node, "output", (Object)output.getResult());
                    node.setOutput(output.getResult().toString());
                    node.setOutputObject(output.getResult());
                    ReportNode parentNode = this.context.getReportNodeCache().get(node.getParentID().toString());
                    if (parentNode != null) {
                        this.context.getVariablesManager().putVariable(parentNode, "previous", (Object)output.getResult());
                    }
                }
                if (output.getAttachments() != null) {
                    for (Attachment a : output.getAttachments()) {
                        try {
                            AttachmentMeta attachmentMeta = this.reportNodeAttachmentManager.createAttachment(AttachmentHelper.hexStringToByteArray((String)a.getHexContent()), a.getName());
                            node.addAttachment(attachmentMeta);
                        }
                        catch (ReportNodeAttachmentManager.AttachmentQuotaException attachmentQuotaException) {}
                    }
                }
                if (output.getMeasures() != null) {
                    node.setMeasures(output.getMeasures());
                }
                String drainOutputValue = (String)testArtefact.getResultMap().get();
                this.drainOutput(drainOutputValue, output);
            }
            finally {
                if (releaseTokenAfterExecution) {
                    this.functionExecutionService.returnTokenHandle(token);
                }
                this.callChildrenArtefacts(node, testArtefact);
            }
        }
        Output output = new Output();
        output.setResult(jprov.createObjectBuilder().build());
        node.setOutputObject(output.getResult());
        node.setOutput(output.getResult().toString());
        node.setStatus(ReportNodeStatus.PASSED);
    }

    private void validateInput(Input input, Function function) {
        if (this.context.getGlobalContext().getConfiguration().getPropertyAsBoolean("enforceschemas", false)) {
            JsonSchemaValidator.validate(function.getSchema().toString(), input.getArgument().toString());
        }
    }

    private Function getFunction(CallFunction testArtefact) {
        Function function;
        if (testArtefact.getFunctionId() != null) {
            function = this.functionRepository.getFunctionById(testArtefact.getFunctionId());
        } else {
            String selectionAttributesJson = (String)testArtefact.getFunction().get();
            Map attributes = this.selectorHelper.buildSelectionAttributesMap(selectionAttributesJson, this.getBindings());
            function = this.functionRepository.getFunctionByAttributes(attributes);
        }
        return function;
    }

    private void drainOutput(String drainOutputValue, Output output) {
        JsonObject resultJson;
        if (drainOutputValue != null && drainOutputValue.trim().length() > 0 && (resultJson = output.getResult()) != null) {
            Object var = this.context.getVariablesManager().getVariable(drainOutputValue);
            if (var instanceof Map) {
                Map<String, String> resultMap = this.jsonToMap(resultJson);
                ((Map)var).putAll(resultMap);
            } else if (var instanceof DataSetHandle) {
                DataSetHandle dataSetHandle = (DataSetHandle)var;
                Map<String, String> resultMap = this.jsonToMap(resultJson);
                for (String key : resultJson.keySet()) {
                    JsonValue jsonValue = (JsonValue)resultJson.get((Object)key);
                    if (!(jsonValue instanceof JsonArray)) continue;
                    JsonArray array = (JsonArray)jsonValue;
                    array.forEach(value -> {
                        if (value.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                            Map<String, String> rowAsMap = this.jsonToMap((JsonObject)value);
                            dataSetHandle.addRow(rowAsMap);
                        }
                    });
                }
                if (!resultMap.isEmpty()) {
                    dataSetHandle.addRow(resultMap);
                }
            } else {
                throw new RuntimeException("The variable '" + drainOutputValue + "' is neither a Map nor a DataSet handle");
            }
        }
    }

    private Map<String, String> jsonToMap(JsonObject jsonOutput) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String key : jsonOutput.keySet()) {
            JsonValue value = (JsonValue)jsonOutput.get((Object)key);
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                resultMap.put(key, jsonOutput.getString(key));
                continue;
            }
            if (value.getValueType().equals((Object)JsonValue.ValueType.OBJECT) || value.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) continue;
            resultMap.put(key, jsonOutput.getString(key).toString());
        }
        return resultMap;
    }

    protected void callChildrenArtefacts(CallFunctionReportNode node, CallFunction testArtefact) {
        if (testArtefact.getChildrenIDs() != null && testArtefact.getChildrenIDs().size() > 0) {
            VariablesManager variableManager = this.context.getVariablesManager();
            variableManager.putVariable((ReportNode)node, "callReport", (Object)node);
            SequentialArtefactScheduler scheduler = new SequentialArtefactScheduler(this.context);
            scheduler.execute_((ReportNode)node, (AbstractArtefact)testArtefact, Boolean.valueOf(true));
        }
    }

    private Input buildInput(String argumentStr) {
        JsonObject argument = this.parseAndResolveJson(argumentStr);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.context.getVariablesManager().getAllVariables().forEach((key, value) -> properties.put((String)key, value != null ? value.toString() : ""));
        properties.put(PARENTREPORTID, ExecutionContext.getCurrentReportNode().getId().toString());
        Input input = new Input();
        input.setArgument(argument);
        input.setProperties(properties);
        return input;
    }

    private JsonObject parseAndResolveJson(String functionStr) {
        JsonObject query;
        try {
            query = functionStr != null && functionStr.trim().length() > 0 ? jprov.createReader((Reader)new StringReader(functionStr)).readObject() : jprov.createObjectBuilder().build();
        }
        catch (JsonParsingException e) {
            throw new RuntimeException("Error while parsing argument (input): " + e.getMessage());
        }
        return this.dynamicJsonObjectResolver.evaluate(query, this.getBindings());
    }

    public CallFunctionReportNode createReportNode_(ReportNode parentNode, CallFunction testArtefact) {
        return new CallFunctionReportNode();
    }
}

