/*
 * Decompiled with CFR 0.152.
 */
package step.core;

import step.attachments.AttachmentManager;
import step.commons.conf.Configuration;
import step.core.GlobalContext;
import step.core.accessors.CollectionRegistry;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.InMemoryArtefactAccessor;
import step.core.artefacts.reports.InMemoryReportNodeAccessor;
import step.core.artefacts.reports.ReportNodeAccessor;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.execution.EventManager;
import step.core.execution.InMemoryExecutionAccessor;
import step.core.execution.model.ExecutionAccessor;
import step.core.plugins.PluginManager;
import step.core.repositories.RepositoryObjectManager;
import step.core.scheduler.ExecutionTaskAccessor;
import step.core.scheduler.InMemoryExecutionTaskAccessor;
import step.expressions.ExpressionHandler;

public class GlobalContextBuilder {
    public static GlobalContext createGlobalContext() {
        GlobalContext context = new GlobalContext();
        context.setExpressionHandler(new ExpressionHandler());
        context.setDynamicBeanResolver(new DynamicBeanResolver(new DynamicValueResolver(context.getExpressionHandler())));
        PluginManager pluginManager = new PluginManager();
        context.setPluginManager(pluginManager);
        context.setConfiguration(Configuration.getInstance());
        context.put(CollectionRegistry.class, (Object)new CollectionRegistry());
        context.setExecutionAccessor((ExecutionAccessor)new InMemoryExecutionAccessor());
        context.setArtefactAccessor((ArtefactAccessor)new InMemoryArtefactAccessor());
        context.setReportAccessor((ReportNodeAccessor)new InMemoryReportNodeAccessor());
        context.setScheduleAccessor((ExecutionTaskAccessor)new InMemoryExecutionTaskAccessor());
        context.setRepositoryObjectManager(new RepositoryObjectManager(context.getArtefactAccessor()));
        context.setEventManager(new EventManager());
        context.setAttachmentManager(new AttachmentManager(Configuration.getInstance()));
        return context;
    }
}

