/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.core.GlobalContext;
import step.core.GlobalContextBuilder;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionRunnable;
import step.core.execution.ExecutionRunnableFactory;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.plugins.AbstractPlugin;
import step.core.repositories.Repository;
import step.core.repositories.RepositoryObjectManager;
import step.core.repositories.RepositoryObjectReference;

public class ExecutionRunnableTest {
    @Test
    public void test() throws Exception {
        GlobalContext globalContext = GlobalContextBuilder.createGlobalContext();
        globalContext.getPluginManager().register(new AbstractPlugin(){

            public void executionStart(ExecutionContext context) {
                context.getVariablesManager().putVariable(context.getReport(), "tec.execution.exports", (Object)"[]");
                super.executionStart(context);
            }
        });
        CheckArtefact artefact = new CheckArtefact(c -> c.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED));
        globalContext.getArtefactAccessor().save((AbstractIdentifiableObject)artefact);
        Repository.ImportResult result = new Repository.ImportResult();
        result.setSuccessful(true);
        result.setArtefactId(artefact.getId().toString());
        TestRepositoryObjectManager repo = new TestRepositoryObjectManager(result, globalContext.getArtefactAccessor());
        globalContext.setRepositoryObjectManager((RepositoryObjectManager)repo);
        ExecutionRunnableFactory f = new ExecutionRunnableFactory(globalContext);
        ExecutionParameters p = new ExecutionParameters("user", null, ExecutionMode.RUN);
        p.setArtefact(new RepositoryObjectReference());
        p.setExports(new ArrayList());
        Execution e = f.createExecution(p, null);
        ExecutionRunnable r = f.newExecutionRunnable(e);
        r.run();
        Execution execution = globalContext.getExecutionAccessor().get(e.getId().toString());
        Assert.assertNotNull((Object)execution);
        Assert.assertNotNull((Object)execution.getStartTime());
        Assert.assertNotNull((Object)execution.getEndTime());
        Assert.assertEquals((Object)ExecutionStatus.ENDED, (Object)execution.getStatus());
        Assert.assertNull((Object)execution.getExecutionTaskID());
        ReportNode node = (ReportNode)globalContext.getReportAccessor().getReportNodesByExecutionIDAndArtefactID(e.getId().toString(), artefact.getId().toString()).next();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node.getStatus());
    }

    private static class TestRepositoryObjectManager
    extends RepositoryObjectManager {
        private Repository.ImportResult result;

        public TestRepositoryObjectManager(Repository.ImportResult result, ArtefactAccessor artefactAccessor) {
            super(artefactAccessor);
            this.result = result;
        }

        public Repository.ImportResult importArtefact(ExecutionContext context, RepositoryObjectReference artefact) throws Exception {
            return this.result;
        }
    }
}

