/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Test;
import step.attachments.AttachmentManager;
import step.commons.conf.Configuration;
import step.core.export.ExportTaskManager;

public class ExportTaskManagerTest {
    @Test
    public void test() throws InterruptedException {
        AttachmentManager am = new AttachmentManager(new Configuration());
        ExportTaskManager m = new ExportTaskManager(new AttachmentManager(new Configuration()));
        final AtomicInteger i = new AtomicInteger(0);
        ExportTaskManager.ExportStatus s = m.createExportTask(new ExportTaskManager.ExportRunnable(){

            protected void runExport() throws Exception {
                i.incrementAndGet();
                File f = new File(this.getContainer() + "/test");
                f.createNewFile();
            }
        });
        Thread.sleep(100L);
        Assert.assertEquals((int)1, (int)i.get());
        Assert.assertEquals((int)1, (int)m.exportStatusMap.size());
        s = m.getExportStatus(s.getId());
        Assert.assertTrue((boolean)s.ready);
        Assert.assertEquals((int)0, (int)m.exportStatusMap.size());
        am.deleteContainer(s.getAttachmentID());
    }

    @Test
    public void testException() throws InterruptedException {
        AttachmentManager am = new AttachmentManager(new Configuration());
        ExportTaskManager m = new ExportTaskManager(new AttachmentManager(new Configuration()));
        ExportTaskManager.ExportStatus s = m.createExportTask(new ExportTaskManager.ExportRunnable(){

            protected void runExport() throws Exception {
                throw new RuntimeException();
            }
        });
        Thread.sleep(100L);
        s = m.getExportStatus(s.getId());
        Assert.assertTrue((boolean)s.ready);
        Assert.assertEquals((int)0, (int)m.exportStatusMap.size());
        am.deleteContainer(s.getAttachmentID());
    }
}

