/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import com.mongodb.MongoClient;
import org.mockito.Mockito;
import step.attachments.AttachmentManager;
import step.commons.conf.Configuration;
import step.core.GlobalContext;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.InMemoryArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.InMemoryReportNodeAccessor;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeAccessor;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.execution.EventManager;
import step.core.execution.ExecutionContext;
import step.core.execution.InMemoryExecutionAccessor;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.miscellaneous.ReportNodeAttachmentManager;
import step.core.plugins.PluginManager;
import step.core.repositories.RepositoryObjectManager;
import step.core.scheduler.ExecutionTaskAccessor;
import step.expressions.ExpressionHandler;

public class ExecutionTestHelper {
    public static ExecutionContext setupContext() {
        ExecutionContext c = ExecutionTestHelper.createContext();
        c.getVariablesManager().putVariable(c.getReport(), ReportNodeAttachmentManager.QUOTA_VARNAME, (Object)100);
        c.getVariablesManager().putVariable(c.getReport(), ArtefactHandler.CONTINUE_EXECUTION, (Object)"false");
        ExecutionContext.setCurrentContext((ExecutionContext)c);
        return c;
    }

    public static ExecutionContext createContext() {
        GlobalContext g = ExecutionTestHelper.createGlobalContext();
        ExecutionContext c = ExecutionTestHelper.createContext(g);
        return c;
    }

    public static ExecutionContext createContext(GlobalContext g) {
        ReportNode root = new ReportNode();
        ExecutionContext c = new ExecutionContext("");
        c.setGlobalContext(g);
        c.getReportNodeCache().put(root);
        c.setReport(root);
        ExecutionContext.setCurrentReportNode((ReportNode)root);
        c.setExecutionParameters(new ExecutionParameters("dummy", null, ExecutionMode.RUN));
        return c;
    }

    public static GlobalContext createGlobalContext() {
        GlobalContext context = new GlobalContext();
        context.setExpressionHandler(new ExpressionHandler());
        context.setDynamicBeanResolver(new DynamicBeanResolver(new DynamicValueResolver(context.getExpressionHandler())));
        PluginManager pluginManager = new PluginManager();
        context.setPluginManager(pluginManager);
        MongoClient client = (MongoClient)Mockito.mock(MongoClient.class);
        context.setMongoClient(client);
        context.setConfiguration(Configuration.getInstance());
        context.setExecutionAccessor((ExecutionAccessor)new InMemoryExecutionAccessor());
        context.setArtefactAccessor((ArtefactAccessor)new InMemoryArtefactAccessor());
        context.setReportAccessor((ReportNodeAccessor)new InMemoryReportNodeAccessor());
        ExecutionTaskAccessor schedulerAccessor = (ExecutionTaskAccessor)Mockito.mock(ExecutionTaskAccessor.class);
        context.setScheduleAccessor(schedulerAccessor);
        context.setRepositoryObjectManager(new RepositoryObjectManager(context.getArtefactAccessor()));
        context.setEventManager(new EventManager());
        context.setAttachmentManager(new AttachmentManager(Configuration.getInstance()));
        return context;
    }
}

