/*
 * Decompiled with CFR 0.152.
 */
package step.core.plans.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import junit.framework.Assert;
import step.core.plans.runner.PlanRunnerResult;

public class PlanRunnerResultAssert {
    public static void assertEquals(File expectedFile, File actualFile) throws IOException {
        Assert.assertEquals((String)PlanRunnerResultAssert.readResource(expectedFile), (String)PlanRunnerResultAssert.readResource(actualFile));
    }

    public static void assertEquals(Class<?> clazz, String expectedResourceName, File actualFile, String ... ignoredPatterns) throws IOException {
        String expected = PlanRunnerResultAssert.readResource(clazz, expectedResourceName);
        expected = PlanRunnerResultAssert.removeIgnoredPatterns(expected, ignoredPatterns);
        String actual = PlanRunnerResultAssert.readResource(actualFile);
        actual = PlanRunnerResultAssert.removeIgnoredPatterns(actual, ignoredPatterns);
        Assert.assertEquals((String)expected, (String)actual);
    }

    protected static String removeIgnoredPatterns(String text, String ... ignoredPatterns) {
        String result = text;
        for (String pattern : ignoredPatterns) {
            result = text.replaceAll(pattern, "");
        }
        return result;
    }

    public static void assertEquals(File expectedReportTreeFile, PlanRunnerResult actualResult) throws IOException {
        StringWriter writer = new StringWriter();
        actualResult.printTree((Writer)writer);
        Assert.assertEquals((String)PlanRunnerResultAssert.readResource(expectedReportTreeFile), (String)writer.toString());
    }

    public static void assertEquals(Class<?> clazz, String resourceName, PlanRunnerResult actualResult) throws IOException {
        StringWriter writer = new StringWriter();
        actualResult.printTree((Writer)writer);
        Assert.assertEquals((String)PlanRunnerResultAssert.readResource(clazz, resourceName), (String)writer.toString());
    }

    public static String readResource(Class<?> clazz, String resourceName) {
        return PlanRunnerResultAssert.readStream(clazz.getResourceAsStream(resourceName));
    }

    public static String readResource(File resource) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(resource);){
            String string = PlanRunnerResultAssert.readStream(fis);
            return string;
        }
    }

    public static String readStream(InputStream is) {
        try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next().replaceAll("\r\n", "\n");
            return string;
        }
    }
}

